/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.impl.util;

import java.io.File;
import java.io.FileNotFoundException;

public class UtilFileName {
    private UtilFileName() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFile(File file, String newName, boolean keepExtension) throws FileNotFoundException {
        File file2 = file;
        synchronized (file2) {
            if (!file.isFile()) {
                throw new FileNotFoundException("cannot access file \"" + file + "\"");
            }
            String fileNameExtension = UtilFileName.getFileExtension(file);
            if (keepExtension) {
                return file.renameTo(new File(file.getParentFile(), newName + fileNameExtension));
            }
            return file.renameTo(new File(file.getParentFile(), newName));
        }
    }

    public static String getNewFileName(File file, String newName) {
        String fileName = file.getName();
        int posOfExt = fileName.lastIndexOf(".");
        if (posOfExt < 0) {
            return newName;
        }
        String ext = fileName.substring(posOfExt, fileName.length());
        return newName + ext;
    }

    public static File appendToFileName(File file, String string) {
        String raw = UtilFileName.getRawFileName(file);
        String nameNew = raw + string + UtilFileName.getFileExtension(file);
        File result = new File(file.getParent(), nameNew);
        return result;
    }

    public static String getRawFileName(File file) {
        String fileName = file.getName();
        int posOfExt = fileName.lastIndexOf(".");
        if (posOfExt < 0) {
            return fileName;
        }
        return fileName.substring(0, posOfExt);
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int posOfExt = fileName.lastIndexOf(".");
        if (posOfExt < 0) {
            return "";
        }
        return fileName.substring(posOfExt, fileName.length());
    }
}

