/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ArithmeticSavety {
    public static final BigInteger BIG_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger BIG_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger BIG_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger BIG_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigDecimal BIG_MAX_DECIMAL = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal BIG_MIN_DECIMAL = BigDecimal.valueOf(Double.MIN_VALUE);

    public static void rangeCheckInteger(BigInteger b) {
        if (b.compareTo(BIG_MAX_INT) == 1 || b.compareTo(BIG_MIN_INT) == -1) {
            throw new ArithmeticException("Integer overflow");
        }
    }

    public static void rangeCheckLong(BigInteger b) {
        if (b.compareTo(BIG_MAX_LONG) == 1 || b.compareTo(BIG_MIN_LONG) == -1) {
            throw new ArithmeticException("Double overflow");
        }
    }

    public static void rangeCheckDouble(BigDecimal b) {
        if (b.compareTo(BIG_MAX_DECIMAL) == 1 || b.compareTo(BIG_MIN_DECIMAL) == -1) {
            throw new ArithmeticException("Double overflow");
        }
    }

    public static int addInt(int a, int b) {
        BigInteger bb = BigInteger.valueOf(a).add(BigInteger.valueOf(b));
        ArithmeticSavety.rangeCheckInteger(bb);
        return bb.intValue();
    }

    public static long addLong(long a, long b) {
        BigInteger bb = BigInteger.valueOf(a).add(BigInteger.valueOf(b));
        ArithmeticSavety.rangeCheckLong(bb);
        return bb.longValue();
    }

    public static int multiply(int a, int b) {
        BigInteger bb = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
        ArithmeticSavety.rangeCheckInteger(bb);
        return bb.intValue();
    }

    public static long multiply(long a, long b) {
        BigInteger bb = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
        ArithmeticSavety.rangeCheckLong(bb);
        return bb.longValue();
    }

    public static double multiply(double a, double b) {
        BigDecimal bb = BigDecimal.valueOf(a).multiply(BigDecimal.valueOf(b));
        ArithmeticSavety.rangeCheckDouble(bb);
        return bb.doubleValue();
    }

    public static Integer increment(Integer integer) {
        return ArithmeticSavety.addInt(integer, 1);
    }

    public static Integer add(Integer integer1, Integer integer2) {
        return ArithmeticSavety.addInt(integer1, integer2);
    }
}

