/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import net.sf.kerner.utils.math.ArithmeticSavety;
import net.sf.kerner.utils.math.PrefixableDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DoubleUnit implements PrefixableDouble
{
    PICO{

        public double toPicos(double units) {
            return units;
        }

        public double toNanos(double units) {
            return units / 1000.0;
        }

        public double toMicros(double units) {
            return units / 1000000.0;
        }

        public double toMillis(double units) {
            return units / 1.0E9;
        }

        public double toUnits(double units) {
            return units / 1.0E12;
        }

        public double toKilos(double units) {
            return units / 1.0E15;
        }

        public double toMegas(double units) {
            return units / 1.0E18;
        }

        public double toGigas(double units) {
            return units / 1.0E21;
        }

        public double toTeras(double units) {
            return units / 1.0E24;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toPicos(units);
        }
    }
    ,
    NANO{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toNanos(double units) {
            return units;
        }

        public double toMicros(double units) {
            return units / 1000.0;
        }

        public double toMillis(double units) {
            return units / 1000000.0;
        }

        public double toUnits(double units) {
            return units / 1.0E9;
        }

        public double toKilos(double units) {
            return units / 1.0E12;
        }

        public double toMegas(double units) {
            return units / 1.0E15;
        }

        public double toGigas(double units) {
            return units / 1.0E18;
        }

        public double toTeras(double units) {
            return units / 1.0E21;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toNanos(units);
        }
    }
    ,
    MICRO{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toMicros(double units) {
            return units;
        }

        public double toMillis(double units) {
            return units / 1000.0;
        }

        public double toUnits(double units) {
            return units / 1000000.0;
        }

        public double toKilos(double units) {
            return units / 1.0E9;
        }

        public double toMegas(double units) {
            return units / 1.0E12;
        }

        public double toGigas(double units) {
            return units / 1.0E15;
        }

        public double toTeras(double units) {
            return units / 1.0E18;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toMicros(units);
        }
    }
    ,
    MILLI{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toMillis(double units) {
            return units;
        }

        public double toUnits(double units) {
            return units / 1000.0;
        }

        public double toKilos(double units) {
            return units / 1000000.0;
        }

        public double toMegas(double units) {
            return units / 1.0E9;
        }

        public double toGigas(double units) {
            return units / 1.0E12;
        }

        public double toTeras(double units) {
            return units / 1.0E15;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toMillis(units);
        }
    }
    ,
    UNIT{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E12);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toMillis(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toUnits(double units) {
            return units;
        }

        public double toKilos(double units) {
            return units / 1000.0;
        }

        public double toMegas(double units) {
            return units / 1000000.0;
        }

        public double toGigas(double units) {
            return units / 1.0E9;
        }

        public double toTeras(double units) {
            return units / 1.0E12;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toUnits(units);
        }
    }
    ,
    KILO{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E15);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E12);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toMillis(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toUnits(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toKilos(double units) {
            return units;
        }

        public double toMegas(double units) {
            return units / 1000.0;
        }

        public double toGigas(double units) {
            return units / 1000000.0;
        }

        public double toTeras(double units) {
            return units / 1.0E9;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toKilos(units);
        }
    }
    ,
    MEGA{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E18);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E15);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1.0E12);
        }

        public double toMillis(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toUnits(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toKilos(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toMegas(double units) {
            return units;
        }

        public double toGigas(double units) {
            return units / 1000.0;
        }

        public double toTeras(double units) {
            return units / 1000000.0;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toMegas(units);
        }
    }
    ,
    GIGA{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E21);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E18);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1.0E15);
        }

        public double toMillis(double units) {
            return ArithmeticSavety.multiply(units, 1.0E12);
        }

        public double toUnits(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toKilos(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toMegas(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toGigas(double units) {
            return units;
        }

        public double toTeras(double units) {
            return units / 1000.0;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toGigas(units);
        }
    }
    ,
    TERA{

        public double toPicos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E24);
        }

        public double toNanos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E21);
        }

        public double toMicros(double units) {
            return ArithmeticSavety.multiply(units, 1.0E18);
        }

        public double toMillis(double units) {
            return ArithmeticSavety.multiply(units, 1.0E15);
        }

        public double toUnits(double units) {
            return ArithmeticSavety.multiply(units, 1.0E12);
        }

        public double toKilos(double units) {
            return ArithmeticSavety.multiply(units, 1.0E9);
        }

        public double toMegas(double units) {
            return ArithmeticSavety.multiply(units, 1000000.0);
        }

        public double toGigas(double units) {
            return ArithmeticSavety.multiply(units, 1000.0);
        }

        public double toTeras(double units) {
            return units;
        }

        public double convert(double units, DoubleUnit unit) {
            return unit.toTeras(units);
        }
    };

    static final double C0 = 1.0;
    static final double C1 = 1000.0;
    static final double C2 = 1000000.0;
    static final double C3 = 1.0E9;
    static final double C4 = 1.0E12;
    static final double C5 = 1.0E15;
    static final double C6 = 1.0E18;
    static final double C7 = 1.0E21;
    static final double C8 = 1.0E24;

    @Override
    public double toPicos(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toNanos(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toMicros(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toMillis(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toUnits(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toKilos(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toMegas(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toGigas(double units) {
        throw new AbstractMethodError();
    }

    @Override
    public double toTeras(double units) {
        throw new AbstractMethodError();
    }

    public double convert(double units, DoubleUnit unit) {
        throw new AbstractMethodError();
    }
}

