/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import net.sf.kerner.utils.math.ArithmeticSavety;
import net.sf.kerner.utils.math.PrefixableLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LongUnit implements PrefixableLong
{
    PICO{

        public long toPicos(long units) {
            return units;
        }

        public long toNanos(long units) {
            return units / 1000L;
        }

        public long toMicros(long units) {
            return units / 1000000L;
        }

        public long toMillis(long units) {
            return units / 1000000000L;
        }

        public long toUnits(long units) {
            return units / 1000000000000L;
        }

        public long toKilos(long units) {
            return units / 1000000000000000L;
        }

        public long toMegas(long units) {
            return units / 1000000000000000000L;
        }

        public long toGigas(long units) {
            return units / 3875820019684212736L;
        }

        public long toTeras(long units) {
            return units / 2003764205206896640L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toPicos(units);
        }
    }
    ,
    NANO{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toNanos(long units) {
            return units;
        }

        public long toMicros(long units) {
            return units / 1000L;
        }

        public long toMillis(long units) {
            return units / 1000000L;
        }

        public long toUnits(long units) {
            return units / 1000000000L;
        }

        public long toKilos(long units) {
            return units / 1000000000000L;
        }

        public long toMegas(long units) {
            return units / 1000000000000000L;
        }

        public long toGigas(long units) {
            return units / 3875820019684212L;
        }

        public long toTeras(long units) {
            return units / 2003764205206896L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toNanos(units);
        }
    }
    ,
    MICRO{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000000L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toMicros(long units) {
            return units;
        }

        public long toMillis(long units) {
            return units / 1000L;
        }

        public long toUnits(long units) {
            return units / 1000000L;
        }

        public long toKilos(long units) {
            return units / 1000000000L;
        }

        public long toMegas(long units) {
            return units / 1000000000000L;
        }

        public long toGigas(long units) {
            return units / 3875820019684L;
        }

        public long toTeras(long units) {
            return units / 2003764205206L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toMicros(units);
        }
    }
    ,
    MILLI{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 1000000L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toMillis(long units) {
            return units;
        }

        public long toUnits(long units) {
            return units / 1000L;
        }

        public long toKilos(long units) {
            return units / 1000000L;
        }

        public long toMegas(long units) {
            return units / 1000000000L;
        }

        public long toGigas(long units) {
            return units / 3875820019L;
        }

        public long toTeras(long units) {
            return units / 2003764205L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toMillis(units);
        }
    }
    ,
    UNIT{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 1000000L);
        }

        public long toMillis(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toUnits(long units) {
            return units;
        }

        public long toKilos(long units) {
            return units / 1000L;
        }

        public long toMegas(long units) {
            return units / 1000000L;
        }

        public long toGigas(long units) {
            return units / 3875820L;
        }

        public long toTeras(long units) {
            return units / 2003764L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toUnits(units);
        }
    }
    ,
    KILO{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000000L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 1000000000L);
        }

        public long toMillis(long units) {
            return ArithmeticSavety.multiply(units, 1000000L);
        }

        public long toUnits(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toKilos(long units) {
            return units;
        }

        public long toMegas(long units) {
            return units / 1000L;
        }

        public long toGigas(long units) {
            return units / 3875L;
        }

        public long toTeras(long units) {
            return units / 2003L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toKilos(units);
        }
    }
    ,
    MEGA{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000000000L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000000L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 1000000000000L);
        }

        public long toMillis(long units) {
            return ArithmeticSavety.multiply(units, 1000000000L);
        }

        public long toUnits(long units) {
            return ArithmeticSavety.multiply(units, 1000000L);
        }

        public long toKilos(long units) {
            return ArithmeticSavety.multiply(units, 1000L);
        }

        public long toMegas(long units) {
            return units;
        }

        public long toGigas(long units) {
            return units / 3L;
        }

        public long toTeras(long units) {
            return units / 2L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toMegas(units);
        }
    }
    ,
    GIGA{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 3875820019684212736L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 3875820019684212L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 3875820019684L);
        }

        public long toMillis(long units) {
            return ArithmeticSavety.multiply(units, 3875820019L);
        }

        public long toUnits(long units) {
            return ArithmeticSavety.multiply(units, 3875820L);
        }

        public long toKilos(long units) {
            return ArithmeticSavety.multiply(units, 3875L);
        }

        public long toMegas(long units) {
            return ArithmeticSavety.multiply(units, 3L);
        }

        public long toGigas(long units) {
            return units;
        }

        public long toTeras(long units) {
            return units / 0L;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toGigas(units);
        }
    }
    ,
    TERA{

        public long toPicos(long units) {
            return ArithmeticSavety.multiply(units, 2003764205206896640L);
        }

        public long toNanos(long units) {
            return ArithmeticSavety.multiply(units, 2003764205206896L);
        }

        public long toMicros(long units) {
            return ArithmeticSavety.multiply(units, 2003764205206L);
        }

        public long toMillis(long units) {
            return ArithmeticSavety.multiply(units, 2003764205L);
        }

        public long toUnits(long units) {
            return ArithmeticSavety.multiply(units, 2003764L);
        }

        public long toKilos(long units) {
            return ArithmeticSavety.multiply(units, 2003L);
        }

        public long toMegas(long units) {
            return ArithmeticSavety.multiply(units, 2L);
        }

        public long toGigas(long units) {
            return ArithmeticSavety.multiply(units, 0L);
        }

        public long toTeras(long units) {
            return units;
        }

        public long convert(long units, LongUnit unit) {
            return unit.toTeras(units);
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 1000000000000L;
    static final long C5 = 1000000000000000L;
    static final long C6 = 1000000000000000000L;
    static final long C7 = 3875820019684212736L;
    static final long C8 = 2003764205206896640L;

    @Override
    public long toPicos(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toNanos(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toMicros(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toMillis(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toUnits(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toKilos(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toMegas(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toGigas(long units) {
        throw new AbstractMethodError();
    }

    @Override
    public long toTeras(long units) {
        throw new AbstractMethodError();
    }

    public long convert(long units, LongUnit unit) {
        throw new AbstractMethodError();
    }
}

