/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

public class Point {
    private final double x;
    private final double y;

    public Point(double x, double y) {
        this.y = y;
        this.x = x;
    }

    public Point(Point template) {
        this(template.x, template.y);
    }

    public static final double getSlope(Point one, Point tow) {
        double b = Point.getDeltaX(one, tow);
        if (b == 0.0) {
            return 0.0;
        }
        return Point.getDeltaY(one, tow) / b;
    }

    static final double getDeltaY(Point one, Point two) {
        return two.y - one.y;
    }

    static final double getDeltaX(Point one, Point two) {
        return two.x - one.x;
    }

    public final double getDistance(Point two) {
        return Math.sqrt(Math.pow(Point.getDeltaX(this, two), 2.0) + Math.pow(Point.getDeltaY(this, two), 2.0));
    }

    public final double getSlope(Point two) {
        return Point.getSlope(this, two);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "[x=" + this.x + ",y=" + this.y + "]";
    }
}

