/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import java.util.ArrayList;
import java.util.List;

public class Polynomial {
    private final List<Double> elements;

    public Polynomial(int size) {
        this.elements = new ArrayList<Double>(size);
    }

    public Polynomial() {
        this(10);
    }

    public synchronized double calculate(double y) {
        double result = 0.0;
        for (int x = this.elements.size() - 1; x > -1; --x) {
            double d = this.elements.get(x);
            if (x > 0) {
                result += d * Math.pow(y, x);
                continue;
            }
            result += d;
        }
        return result;
    }

    public synchronized void add(int pos, double element) {
        this.elements.add(pos, element);
    }

    public synchronized Polynomial getDerivate() {
        Polynomial result = new Polynomial();
        for (int i = 1; i < this.elements.size(); ++i) {
            double element = this.elements.get(i);
            result.add(i - 1, element * (double)i);
        }
        return result;
    }

    public synchronized Polynomial getDerivate(int nr) {
        if (nr < 1) {
            throw new IllegalArgumentException("nr must be >= 1");
        }
        Polynomial result = this.getDerivate();
        for (int i = 1; i < nr; ++i) {
            result = result.getDerivate();
        }
        return result;
    }

    public synchronized double[] getPolynoms() {
        double[] result = new double[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            result[i] = this.elements.get(i);
        }
        return result;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (int x = this.elements.size() - 1; x > -1; --x) {
            sb.append(String.format("%22.20f", this.elements.get(x)) + (x > 0 ? "x^" + x + "+" : ""));
        }
        return sb.toString().replaceAll("\\s", "");
    }
}

