/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import java.util.Random;

public class RandomFactory {
    private static final Random R = new Random();

    private RandomFactory() {
    }

    public static double generateAround(double value, double delta) {
        double low = value - delta;
        double heigh = value + delta;
        return RandomFactory.generateBetween(low, heigh);
    }

    public static double generateBetween(double low, double high) {
        return low + (high - low) * R.nextDouble();
    }

    public static int generateAround(int value, int delta) {
        int low = value - delta;
        int heigh = value + delta;
        return RandomFactory.generateBetween(low, heigh);
    }

    public static int generateBetween(int low, int high) {
        return low + R.nextInt(high + 1 - low);
    }

    public static boolean generateWithProbability(double probability) {
        if (probability > 1.0) {
            return true;
        }
        if (probability <= 0.0) {
            return false;
        }
        probability = (int)(probability * 100.0);
        int result = RandomFactory.generateBetween(0, 100);
        return (double)result <= probability;
    }

    public static boolean generate() {
        return R.nextBoolean();
    }
}

