/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math;

import java.util.Arrays;
import java.util.Collection;
import net.sf.kerner.utils.impl.util.UtilArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilMath {
    private UtilMath() {
    }

    public static double round(double number, int decimalPlace) {
        int n = decimalPlace;
        int c = 0;
        while (n > 10) {
            n /= 10;
            ++c;
        }
        double factor = Math.pow(10.0, decimalPlace += c);
        double result = (double)Math.round(number * factor) / factor;
        return result;
    }

    public static boolean equals(double d1, double d2, int decimalPlace) {
        double d11 = UtilMath.round(d1, decimalPlace);
        double d22 = UtilMath.round(d2, decimalPlace);
        return Double.valueOf(d11).equals(d22);
    }

    public static double max(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        double result = values[0];
        for (double i : values) {
            if (!(i > result)) continue;
            result = i;
        }
        return result;
    }

    public static double max(Collection<? extends Number> values) {
        return UtilMath.max(UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static double min(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        double result = values[0];
        for (double i : values) {
            if (!(i < result)) continue;
            result = i;
        }
        return result;
    }

    public static double min(Collection<? extends Number> values) {
        return UtilMath.min(UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static double mean(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        return UtilMath.sum(values) / (double)values.length;
    }

    public static double mean(Collection<? extends Number> values) {
        return UtilMath.mean(UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static double median(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        double[] b = new double[values.length];
        System.arraycopy(values, 0, b, 0, b.length);
        Arrays.sort(b);
        if (values.length % 2 == 0) {
            return (b[b.length / 2 - 1] + b[b.length / 2]) / 2.0;
        }
        return b[b.length / 2];
    }

    public static double median(Collection<? extends Number> values) {
        return UtilMath.median(UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static double sum(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        double result = 0.0;
        for (double d : values) {
            result += d;
        }
        return result;
    }

    public static double sum(Collection<Double> values) {
        return UtilMath.sum(UtilArray.toPrimitive(values.toArray(new Double[values.size()])));
    }

    public static double stdDev(double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            return 0.0;
        }
        double sumOfSquares = 0.0;
        double mean = UtilMath.mean(values);
        for (double d : values) {
            double dd = d - mean;
            sumOfSquares += dd * dd;
        }
        return Math.sqrt(sumOfSquares / (double)(values.length - 1));
    }

    public static double stdDev(Collection<? extends Number> values) {
        return UtilMath.stdDev(UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static double getClosest(double number, double ... values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            return values[0];
        }
        double[] arr = UtilArray.copy(values);
        Arrays.sort(arr);
        double result = arr[0];
        double diff = Math.abs(arr[0] - number);
        for (int i = 1; i < arr.length; ++i) {
            double diff2 = Math.abs(arr[i] - number);
            if (!(diff2 < diff)) continue;
            diff = diff2;
            result = arr[i];
        }
        return result;
    }

    public static double getClosest(double number, Collection<? extends Number> values) {
        return UtilMath.getClosest(number, UtilArray.toPrimitive(values.toArray(new Number[values.size()])));
    }

    public static Integer increment(Integer integer) {
        return UtilMath.increment(integer, 1);
    }

    public static Integer increment(Integer integer, int i) {
        return integer + i;
    }

    public static Integer add(Integer integer1, Integer integer2) {
        return integer1 + integer2;
    }

    public static double log2(double number) {
        return Math.log(number) / Math.log(2.0);
    }

    public static double lower(double d1, double d2) {
        if (d1 < d2) {
            return d1;
        }
        return d2;
    }

    public static double higher(double d1, double d2) {
        if (d1 > d2) {
            return d1;
        }
        return d2;
    }

    public static double assertAboveEqual(double number, double value) {
        if (number < value) {
            return value;
        }
        return number;
    }

    public static double assertBelowEqual(double number, double value) {
        if (number > value) {
            return value;
        }
        return number;
    }
}

