/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math.point;

public class Point2D {
    protected final double x;
    protected final double y;

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point2D(Point2D template) {
        this(template.getX(), template.getY());
    }

    public static final double getSlope(Point2D one, Point2D tow) {
        double b = Point2D.getDeltaX(one, tow);
        if (b == 0.0) {
            return 0.0;
        }
        return Point2D.getDeltaY(one, tow) / b;
    }

    public static final double getDeltaY(Point2D one, Point2D two) {
        return two.y - one.y;
    }

    public static final double getDeltaX(Point2D one, Point2D two) {
        return two.x - one.x;
    }

    public final double getDistance(Point2D two) {
        return Math.sqrt(Math.pow(Point2D.getDeltaX(this, two), 2.0) + Math.pow(Point2D.getDeltaY(this, two), 2.0));
    }

    public final double getSlope(Point2D two) {
        return Point2D.getSlope(this, two);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Point2D)) {
            return false;
        }
        Point2D other = (Point2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "x=" + this.getX() + ",y=" + this.getY();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

