/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.math.point;

import net.sf.kerner.utils.math.point.Point2D;

public class Point3D
extends Point2D {
    protected final double z;

    public Point3D(double x, double y, double z) {
        super(x, y);
        this.z = z;
    }

    public Point3D(Point3D template) {
        this(template.getX(), template.getY(), template.getZ());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Point3D)) {
            return false;
        }
        Point3D other = (Point3D)obj;
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return super.toString() + ",z=" + this.getZ();
    }

    public double getZ() {
        return this.z;
    }
}

