/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.monitor.memory;

import net.sf.kerner.utils.math.LongUnit;
import net.sf.kerner.utils.monitor.memory.MemoryMonitor;

public class SimpleMemoryMonitor
implements MemoryMonitor {
    private long max = -1L;
    private long average = 0L;
    private final LongUnit unit;
    private final long interval;
    private final Object lock = new Object();
    private Thread t = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!SimpleMemoryMonitor.this.t.isInterrupted()) {
                Object object = SimpleMemoryMonitor.this.lock;
                synchronized (object) {
                    long current = SimpleMemoryMonitor.this.getCurrentUsage();
                    if (SimpleMemoryMonitor.this.max < current) {
                        SimpleMemoryMonitor.this.max = current;
                    }
                    SimpleMemoryMonitor.this.average = (SimpleMemoryMonitor.this.average + current) / 2L;
                }
                try {
                    1.sleep(SimpleMemoryMonitor.this.interval);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    };

    public SimpleMemoryMonitor(LongUnit unit, long interval) {
        this.unit = unit;
        this.interval = interval;
    }

    public SimpleMemoryMonitor(long interval) {
        this(DEFAULT_UNIT, interval);
    }

    public SimpleMemoryMonitor() {
        this(DEFAULT_UNIT, 2000L);
    }

    public long getCurrentUsage() {
        return this.getCurrentUsage(this.unit);
    }

    public long getCurrentUsage(LongUnit unit) {
        long result = unit.convert(Runtime.getRuntime().totalMemory(), LongUnit.UNIT);
        return result;
    }

    public synchronized long getMaxUsage() {
        return this.getMaxUsage(this.unit);
    }

    public synchronized long getMaxUsage(LongUnit unit) {
        return this.unit.convert(this.max, unit);
    }

    public synchronized long getAverageUsage() {
        return this.getAverageUsage(this.unit);
    }

    public synchronized long getAverageUsage(LongUnit unit) {
        return this.unit.convert(this.average, unit);
    }

    public void start() {
        this.t.start();
    }

    public synchronized long stop() {
        this.t.interrupt();
        return this.getCurrentUsage();
    }

    public LongUnit getUnit() {
        return this.unit;
    }
}

