/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.swing.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableButton
extends JButton
implements TableCellRenderer,
TableCellEditor {
    private static final long serialVersionUID = 8772175735048815470L;
    private final List<Listener> listener = new ArrayList<Listener>();
    private int selectedColumn;
    private int selectedRow;

    public TableButton(String text) {
        super(text);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (Listener l : TableButton.this.listener) {
                    l.tableButtonClicked(TableButton.this.selectedRow, TableButton.this.selectedColumn);
                }
            }
        });
    }

    public void addCellEditorListener(CellEditorListener arg0) {
    }

    public void addTableButtonListener(Listener l) {
        this.listener.add(l);
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return "";
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.selectedRow = row;
        this.selectedColumn = col;
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        return this;
    }

    public boolean isCellEditable(EventObject arg0) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener arg0) {
    }

    public void removeTableButtonListener(Listener l) {
        this.listener.remove(l);
    }

    public boolean shouldSelectCell(EventObject arg0) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public static interface Listener
    extends EventListener {
        public void tableButtonClicked(int var1, int var2);
    }
}

