/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.time;

import java.util.concurrent.TimeUnit;

public class TimePeriod {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private volatile long start;
    private volatile long stop;
    private final TimeUnit timeUnit;

    public TimePeriod(long start, long stop, TimeUnit timeUnit) {
        this.start = start;
        this.stop = stop;
        this.timeUnit = timeUnit;
    }

    public TimePeriod(long start, long stop) {
        this.start = start;
        this.stop = stop;
        this.timeUnit = DEFAULT_TIME_UNIT;
    }

    public String toString() {
        return Long.toString(this.getDuration());
    }

    public long getStart() {
        return this.getStart(this.timeUnit);
    }

    public long getStop() {
        return this.getStop(this.timeUnit);
    }

    public long getStart(TimeUnit tu) {
        return tu.convert(this.start, this.timeUnit);
    }

    public long getStop(TimeUnit tu) {
        return tu.convert(this.stop, this.timeUnit);
    }

    public long getDuration() {
        return this.getDuration(this.timeUnit);
    }

    public long getDuration(TimeUnit tu) {
        return tu.convert(this.stop - this.start, this.timeUnit);
    }
}

