/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.util.Arrays;
import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.Messages;

public class Jre
implements IValidatable {
    public static final String PATH = "jrepath";
    public static final String MIN_VERSION = "javamin";
    public static final String MAX_VERSION = "javamax";
    public static final String ARGS = "jvmArgs";
    public static final String VERSION_PATTERN = "(\\d\\.){2}\\d(_\\d+)?";
    public static final String JDK_PREFERENCE_JRE_ONLY = "jreOnly";
    public static final String JDK_PREFERENCE_PREFER_JRE = "preferJre";
    public static final String JDK_PREFERENCE_PREFER_JDK = "preferJdk";
    public static final String JDK_PREFERENCE_JDK_ONLY = "jdkOnly";
    public static final String RUNTIME_BITS_64 = "64";
    public static final String RUNTIME_BITS_64_AND_32 = "64/32";
    public static final String RUNTIME_BITS_32 = "32";
    private static final String[] JDK_PREFERENCE_NAMES = new String[]{"jreOnly", "preferJre", "preferJdk", "jdkOnly"};
    private static final String[] RUNTIME_BITS_OPTIONS = new String[]{"64", "64/32", "32"};
    public static final int DEFAULT_JDK_PREFERENCE_INDEX = Arrays.asList(JDK_PREFERENCE_NAMES).indexOf("preferJre");
    public static final int DEFAULT_RUNTIME_BITS_INDEX = Arrays.asList(RUNTIME_BITS_OPTIONS).indexOf("64/32");
    private String path;
    private boolean bundledJre64Bit;
    private String minVersion;
    private String maxVersion;
    private String jdkPreference;
    private String runtimeBits;
    private Integer initialHeapSize;
    private Integer initialHeapPercent;
    private Integer maxHeapSize;
    private Integer maxHeapPercent;
    private List<String> options;

    @Override
    public void checkInvariants() {
        Validator.checkOptString(this.minVersion, 10, VERSION_PATTERN, "jre.minVersion", Messages.getString("Jre.min.version"));
        Validator.checkOptString(this.maxVersion, 10, VERSION_PATTERN, "jre.maxVersion", Messages.getString("Jre.max.version"));
        if (Validator.isEmpty(this.path)) {
            Validator.checkFalse(this.bundledJre64Bit, "jre.bundledJre64Bit", Messages.getString("Jre.bundled.64bit.invalid"));
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.minVersion", Messages.getString("Jre.specify.jre.min.version.or.path"));
        } else {
            Validator.checkString(this.path, 260, "jre.path", Messages.getString("Jre.bundled.path"));
        }
        if (!Validator.isEmpty(this.maxVersion)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.minVersion", Messages.getString("Jre.specify.min.version"));
            Validator.checkTrue(this.minVersion.compareTo(this.maxVersion) < 0, "jre.maxVersion", Messages.getString("Jre.max.greater.than.min"));
        }
        Validator.checkTrue(this.initialHeapSize == null || this.maxHeapSize != null, "jre.maxHeapSize", Messages.getString("Jre.initial.and.max.heap"));
        Validator.checkTrue(this.initialHeapSize == null || this.initialHeapSize > 0, "jre.initialHeapSize", Messages.getString("Jre.initial.heap"));
        Validator.checkTrue(this.maxHeapSize == null || this.maxHeapSize >= (this.initialHeapSize != null ? this.initialHeapSize : 1), "jre.maxHeapSize", Messages.getString("Jre.max.heap"));
        Validator.checkTrue(this.initialHeapPercent == null || this.maxHeapPercent != null, "jre.maxHeapPercent", Messages.getString("Jre.initial.and.max.heap"));
        if (this.initialHeapPercent != null) {
            Validator.checkRange(this.initialHeapPercent, 1, 100, "jre.initialHeapPercent", Messages.getString("Jre.initial.heap.percent"));
        }
        if (this.maxHeapPercent != null) {
            Validator.checkRange(this.maxHeapPercent, this.initialHeapPercent != null ? this.initialHeapPercent : 1, 100, "jre.maxHeapPercent", Messages.getString("Jre.max.heap.percent"));
        }
        Validator.checkIn(this.getJdkPreference(), JDK_PREFERENCE_NAMES, "jre.jdkPreference", Messages.getString("Jre.jdkPreference"));
        Validator.checkIn(this.getRuntimeBits(), RUNTIME_BITS_OPTIONS, "jre.runtimeBits", Messages.getString("Jre.runtimeBits"));
        Validator.checkOptStrings(this.options, 30719, 30719, "[^\"]*|([^\"]*\"[^\"]*\"[^\"]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.unclosed.quotation"));
        Validator.checkOptStrings(this.options, 30719, 30719, "[^%]*|([^%]*([^%]*%[^%]+%[^%]*)+[^%]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.variable"));
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public String getJdkPreference() {
        return Validator.isEmpty(this.jdkPreference) ? JDK_PREFERENCE_PREFER_JRE : this.jdkPreference;
    }

    public void setJdkPreference(String jdkPreference) {
        this.jdkPreference = jdkPreference;
    }

    public int getJdkPreferenceIndex() {
        int x = Arrays.asList(JDK_PREFERENCE_NAMES).indexOf(this.getJdkPreference());
        return x != -1 ? x : DEFAULT_JDK_PREFERENCE_INDEX;
    }

    public void setJdkPreferenceIndex(int x) {
        this.jdkPreference = JDK_PREFERENCE_NAMES[x];
    }

    public String getRuntimeBits() {
        return Validator.isEmpty(this.runtimeBits) ? RUNTIME_BITS_64_AND_32 : this.runtimeBits;
    }

    public void setRuntimeBits(String runtimeBits) {
        this.runtimeBits = runtimeBits;
    }

    public int getRuntimeBitsIndex() {
        int x = Arrays.asList(RUNTIME_BITS_OPTIONS).indexOf(this.getRuntimeBits());
        return x != -1 ? x : DEFAULT_RUNTIME_BITS_INDEX;
    }

    public void setRuntimeBitsIndex(int x) {
        this.runtimeBits = RUNTIME_BITS_OPTIONS[x];
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getBundledJre64Bit() {
        return this.bundledJre64Bit;
    }

    public void setBundledJre64Bit(boolean bundledJre64Bit) {
        this.bundledJre64Bit = bundledJre64Bit;
    }

    public Integer getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public void setInitialHeapSize(Integer initialHeapSize) {
        this.initialHeapSize = this.getInteger(initialHeapSize);
    }

    public Integer getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(Integer maxHeapSize) {
        this.maxHeapSize = this.getInteger(maxHeapSize);
    }

    public Integer getInitialHeapPercent() {
        return this.initialHeapPercent;
    }

    public void setInitialHeapPercent(Integer initialHeapPercent) {
        this.initialHeapPercent = this.getInteger(initialHeapPercent);
    }

    public Integer getMaxHeapPercent() {
        return this.maxHeapPercent;
    }

    public void setMaxHeapPercent(Integer maxHeapPercent) {
        this.maxHeapPercent = this.getInteger(maxHeapPercent);
    }

    private Integer getInteger(Integer i) {
        return i != null && i == 0 ? null : i;
    }
}

