package org.springframework.web.servlet.view.json.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.view.json.JsonExceptionHandler;

public class StackTraceExceptionHandler implements JsonExceptionHandler{
	public static final String STACKTRACE_MODEL_KEY = "exception.stacktrace";
	private String modelKey = STACKTRACE_MODEL_KEY;
	private boolean replaceLineBreakes;
	
	public void triggerException(Exception exception, Map model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		StringWriter swr = new StringWriter();
		exception.printStackTrace(new PrintWriter(swr));
		String stackTrace = swr.getBuffer().toString(); 
		
		if(replaceLineBreakes)
			stackTrace = stackTrace.replaceAll("\n", "</br>");
		
		model.put(modelKey, stackTrace);
	}

	public String getModelKey() {
		return modelKey;
	}

	public void setModelKey(String modelKey) {
		this.modelKey = modelKey;
	}

	public boolean getReplaceLineBreakes() {
		return replaceLineBreakes;
	}

	public void setReplaceLineBreakes(boolean replaceLineBreakes) {
		this.replaceLineBreakes = replaceLineBreakes;
	}
	
	

}
