package org.springframework.web.servlet.view.json.writer.jsonlib;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessorMatcher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.JsonStringWriter;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplateRegistry;

public class JsonlibJsonStringWriter implements JsonStringWriter {
	protected final Log logger = LogFactory.getLog(getClass());

	private boolean enableJsonConfigSupport;
	
	private boolean convertAllMapValues;
	
	@SuppressWarnings("unchecked")
	public void convertAndWrite(Map model, JsonWriterConfiguratorTemplateRegistry configuratorTemplateRegistry, Writer writer, BindingResult br) throws IOException{
		
		JsonConfig jsonConfig = null;
		
		JsonlibJsonWriterConfiguratorTemplate configuratorTemplate = (JsonlibJsonWriterConfiguratorTemplate) configuratorTemplateRegistry.findConfiguratorTemplate(JsonlibJsonWriterConfiguratorTemplate.class.getName());
		
		if(enableJsonConfigSupport && configuratorTemplate != null ){
			jsonConfig = (JsonConfig) configuratorTemplate.getConfigurator();
		}
		
		if(jsonConfig == null)
			jsonConfig = new JsonConfig();
		
		
		if(jsonConfig.getJsonValueProcessorMatcher().getClass().equals(JsonValueProcessorMatcher.DEFAULT.getClass())){
			PropertyEditorRegistry per = null;
			String objektName = null;
			
			if(br != null){
				per = br.getPropertyEditorRegistry();
				objektName = br.getObjectName();
			}
			
			PropertyEditorRegistryValueProcessor valueProzessor = new PropertyEditorRegistryValueProcessor(per);
			valueProzessor.setConvertAllMapValues(convertAllMapValues);
			valueProzessor.setObjektName(objektName);
			
			jsonConfig.registerJsonValueProcessor( AllwaysMatchingValueProcessorMatcher.class, valueProzessor );
			jsonConfig.setJsonValueProcessorMatcher(new AllwaysMatchingValueProcessorMatcher());
			
			jsonConfig.addJsonEventListener(valueProzessor);
			jsonConfig.enableEventTriggering();
			
		}
		
		JSON json = JSONSerializer.toJSON(model, jsonConfig ); 
		if(logger.isDebugEnabled())
			logger.debug(json.toString());
		
		json.write(writer);
		writer.flush();
	}

	public boolean isEnableJsonConfigSupport() {
		return enableJsonConfigSupport;
	}

	public void setEnableJsonConfigSupport(boolean enableJsonConfigSupport) {
		this.enableJsonConfigSupport = enableJsonConfigSupport;
	}

	public boolean isConvertAllMapValues() {
		return convertAllMapValues;
	}

	public void setConvertAllMapValues(boolean convertAllMapValues) {
		this.convertAllMapValues = convertAllMapValues;
	}
	
	

}
