package org.springframework.web.servlet.view.json.writer.xstream;

import org.springframework.web.servlet.view.json.writer.xstream.converter.SimpleDateConverter;
import org.springframework.web.servlet.view.json.writer.xstream.converter.SpringJsonMapConverter;
import org.springframework.web.servlet.view.json.writer.xstream.core.PropertyEditorRegistryConverterLookup;
import org.springframework.web.servlet.view.json.writer.xstream.core.SpringJsonMarshallingStrategy;
import org.springframework.web.servlet.view.json.writer.xstream.io.JsonMapHierarchicalStreamDriver;

import com.thoughtworks.xstream.core.util.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
 
public class SpringJsonXStreamBuilder {
	
	
	public static SpringJsonXStream build(boolean convertAllMapValues, String keepValueTypesMode, String rootname){
		return build(convertAllMapValues, keepValueTypesMode, rootname, false );
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, String keepValueTypesMode, String rootname, boolean prettyPrint){
		
		PropertyEditorRegistryConverterLookup lookup = new PropertyEditorRegistryConverterLookup();
		SpringJsonXStream xstream = new SpringJsonXStream( 
				null, 
				new JsonMapHierarchicalStreamDriver(keepValueTypesMode, prettyPrint), 
				new ClassLoaderReference(new CompositeClassLoader()), 
				null, lookup, null);
		SpringJsonMarshallingStrategy marshallingStrategy  = new SpringJsonMarshallingStrategy(SpringJsonMarshallingStrategy.ABSOLUTE, convertAllMapValues, rootname);
		xstream.setMarshallingStrategy( marshallingStrategy);
		xstream.registerConverter(new SpringJsonMapConverter(xstream.getMapper()));
		xstream.registerConverter(new SimpleDateConverter());
		
		return xstream;
	}
	
	
	
	
}
