package org.springframework.web.servlet.view.json.writer.xstream;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.JsonStringWriter;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplateRegistry;

public class XStreamJsonStringWriter implements JsonStringWriter {
	
	public static final String DEFAULT_ROOTNAME = "model";
	
	private boolean enableJsonConfigSupport;
	
	private boolean convertAllMapValues;
	
	private String keepValueTypesMode = MODE_KEEP_VALUETYPES_NONE;
	
	private String rootname = DEFAULT_ROOTNAME;
	
	public void convertAndWrite(
			Map modelMap,
			JsonWriterConfiguratorTemplateRegistry configuratorTemplateRegistry,
			Writer writer, BindingResult br) throws IOException {
		
		XStreamJsonWriterConfiguratorTemplate configuratorTemplate = ( XStreamJsonWriterConfiguratorTemplate) configuratorTemplateRegistry.findConfiguratorTemplate( XStreamJsonWriterConfiguratorTemplate.class.getName());
		
		SpringJsonXStream xstream = null;
		
		if(enableJsonConfigSupport && configuratorTemplate != null ){
			xstream = (SpringJsonXStream) configuratorTemplate.getConfigurator();
		}
		
		if(xstream == null)
			xstream = SpringJsonXStreamBuilder.build(convertAllMapValues, keepValueTypesMode, rootname);
		
		xstream.setBindingResult(br);
		
		xstream.toXML(modelMap, writer);
		
	}

	public boolean getEnableJsonConfigSupport() {
		return enableJsonConfigSupport;
	}

	public void setEnableJsonConfigSupport(boolean enableJsonConfigSupport) {
		this.enableJsonConfigSupport = enableJsonConfigSupport;
	}

	public boolean getConvertAllMapValues() {
		return convertAllMapValues;
	}

	public void setConvertAllMapValues(boolean convertAllMapValues) {
		this.convertAllMapValues = convertAllMapValues;
	}
	
	public String getKeepValueTypesMode() {
		return keepValueTypesMode;
	}

	public void setKeepValueTypesMode(String keepValueTypesMode) {
		this.keepValueTypesMode = keepValueTypesMode;
	}

	public String getRootname() {
		return rootname;
	}

	public void setRootname(String rootname) {
		this.rootname = rootname;
	}

}
