
package org.springframework.web.servlet.view.json.writer.xstream.converter;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.springframework.ui.ModelMap;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

public class SpringJsonMapConverter extends MapConverter{
	public SpringJsonMapConverter(Mapper mapper) {
        super(mapper);
    }
	
	public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map) source;
        for (Iterator iterator = map.entrySet().iterator(); iterator.hasNext();) {
            Map.Entry entry = (Map.Entry) iterator.next();
            if(entry.getValue() != null){
            	ExtendedHierarchicalStreamWriterHelper.startNode(writer, entry.getKey().toString(), entry.getValue().getClass());
                context.convertAnother(entry.getValue());
                writer.endNode();
            }
           
        }
	}
	
	public boolean canConvert(Class type) {
        return type.equals(HashMap.class)
                || type.equals(ModelMap.class)
                || type.equals(Hashtable.class)
                || type.getName().equals("java.util.LinkedHashMap")
                || type.getName().equals("sun.font.AttributeMap") // Used by java.awt.Font in JDK 6
                ;
    }

}
