package org.springframework.web.servlet.view.json.writer.xstream.core;

import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindingResult;

import com.thoughtworks.xstream.core.DefaultConverterLookup;

public class PropertyEditorRegistryConverterLookup extends DefaultConverterLookup{
	private BindingResult bindingResult;

	public BindingResult getBindingResult() {
		return bindingResult;
	}

	public void setBindingResult(BindingResult bindingResult) {
		this.bindingResult = bindingResult;
	}

	public boolean existsPropertyEditorRegistry(){
		return (bindingResult != null && bindingResult.getPropertyEditorRegistry() != null);
	}
	
	
	public PropertyEditorRegistry getPropertyEditorRegistry(){
		if(bindingResult != null)
			return bindingResult.getPropertyEditorRegistry();
		else
			return null;
	}
	
}
