package org.springframework.web.servlet.view.json.writer.xstream.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;


public class JsonMapHierarchicalStreamDriver implements HierarchicalStreamDriver {
	private String keepValueTypesMode;
	private boolean prettyPrint;
	
	public JsonMapHierarchicalStreamDriver(String keepValueTypesMode, boolean prettyPrint){
		this.keepValueTypesMode = keepValueTypesMode;
		this.prettyPrint = prettyPrint;
	}
	
    public HierarchicalStreamReader createReader(Reader in) {
        throw new UnsupportedOperationException("The JsonHierarchicalStreamDriver can only write JSON");
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        throw new UnsupportedOperationException("The JsonHierarchicalStreamDriver can only write JSON");
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
    	if(!prettyPrint)
    		return new JsonMapHierarchicalStreamWriter(out, keepValueTypesMode, new char[]{}, "");
    	else
    		return new JsonMapHierarchicalStreamWriter(out, keepValueTypesMode, new char[]{' ', ' '}, "\n");
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        try {
            return createWriter(new OutputStreamWriter(out, "UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
    }

	public boolean getPrettyPrint() {
		return prettyPrint;
	}
    
}