package org.springframework.web.servlet.view.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement.Typ;

public class CommonsBeanUtilsPath {
	public static final String NONE		= "NONE";
	public static final String SIMPLE 	= "SIMPLE";
	public static final String DEAP 	= "DEAP";
	
	public static final int SHORT 		= 0;
	public static final int NORMAL 		= 1;

	private CommonsBeanUtilsPathElement[] elements;
	private int mode;

	public CommonsBeanUtilsPath(CommonsBeanUtilsPathElement[] elements, int mode) {
		this.elements = elements;
		this.mode = mode;
	}

	private StringBuffer toStringBuffer() {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < elements.length - 1; i++) {
			CommonsBeanUtilsPathElement e = elements[i];

			if (e.getTyp().equals(Typ.MAP)) {
				if (!parentIsArray(i))
					buffer.append(e.getName());
				if (parentIsMap(i)) {
					buffer.append(')');
				}
				if (hasChild(i))
					buffer.append('(');

			} else if (e.getTyp().equals(Typ.SIMPEL)) {

				if (!parentIsArray(i))
					buffer.append(e.getName());
				if (parentIsMap(i)) {
					buffer.append(')');
				}
				if (hasChild(i))
					buffer.append('.');

			}else{
				if (!parentIsArray(i))
					buffer.append(e.getName());

				if (parentIsMap(i)) {
					buffer.append(')');
				}
				if(hasChild(i) && !childIsBean(i))
					buffer.append('[').append(getChild(i-1).getIndex()-1).append( ']');
				else if (hasChild(i))
					buffer.append('[').append(getChild(i).getIndex()-1).append( ']');

			}
		}

		if (mode != SHORT) {
			int i = elements.length - 1;

			CommonsBeanUtilsPathElement e = elements[i];

			if (parentIsArray(i))
				buffer.append('[').append(e.getIndex()).append(']');
			else if (parentIsMap(i)) {
				buffer.append('(').append(e.getName()).append(')');
			} else{
				buffer.append('.').append(e.getName());
			}
		}
		return buffer;

	}
	
	public String toString() {
		return toStringBuffer().toString();

	}

	private boolean parentIsMap(int index) {
		if (index > 0) {
			return (CommonsBeanUtilsPathElement.Typ.MAP
					.equals(elements[index - 1].getTyp()));
		} else
			return false;
	}

	private boolean parentIsArray(int index) {
		if (index > 0) {
			return (CommonsBeanUtilsPathElement.Typ.ARRAY
					.equals(elements[index - 1].getTyp()));
		} else
			return false;
	}

	private boolean hasChild(int index) {
		return (elements.length - 1 > (index + 1));
	}
	
	private boolean childIsBean(int index) {
		if(elements.length - 1 > (index + 2) && index > 2){
			Typ child1_Typ = elements[index - 1].getTyp();
			Typ child2_Typ = elements[index - 2].getTyp();
			return (Typ.SIMPEL.equals(child1_Typ) && Typ.SIMPEL.equals(child2_Typ));
		}else
			return false; 
		
	}

	private CommonsBeanUtilsPathElement getChild(int index) {
		return elements[index + 1];
	}
	
	public Set<String> getImplicitIndexedPath(String deep){
		return getImplicitIndexedPath(toStringBuffer() , deep);
	}
	
	public Set<String> getImplicitIndexedPath(StringBuffer sb , String deep){
		Set<String> implicitIndexedPaths = new HashSet<String>();
		if(NONE.equals(deep)){
			implicitIndexedPaths.add(sb.toString());
		} else  if(SIMPLE.equals(deep)){
			implicitIndexedPaths.add(sb.toString());
			
			int startindex =  sb.lastIndexOf("[");
			int endindex =   sb.lastIndexOf("]");
			int endindex1 =   sb.lastIndexOf("].");
			int lastDot1 =   sb.lastIndexOf(".");
			
			if(endindex == sb.length() -1)
				sb.delete(startindex, endindex +1);
			else if(endindex1 + 1 == lastDot1)
				sb.delete(startindex, endindex +1);
			implicitIndexedPaths.add(sb.toString());
		} else if(DEAP.equals(deep)){
			List<int[]> iLst = new ArrayList<int[]>();
			
			int startindex =  sb.indexOf("[", 0);
			int endindex =   sb.indexOf("]", 0);
			while(startindex != -1){
				iLst.add(new int[]{startindex,endindex});
				startindex =  sb.indexOf("[", endindex +1);
				endindex =   sb.indexOf("]", endindex +1);
			}
			
			Integer[][] perm = Permutation.power(iLst.size());
			for(int i = 0; i < perm.length; i++){
				StringBuffer ib = new StringBuffer().append(sb);
				int delta = 0;
				Integer[] replaceIndexs = perm[i];
				for(int j = 0; j < replaceIndexs.length; j++){
					int[] ix = iLst.get(replaceIndexs[j]);
					ib.delete(ix[0]- delta, ix[1] + 1 - delta);
					delta = delta + ix[1] - ix[0] + 1;
				}
				implicitIndexedPaths.add(ib.toString());
			}
			
		} else if(!NONE.equals(deep)){
			throw new IllegalArgumentException("Argument : " + deep + " unknown. Please use NONE, SIMPLE, DEAP");
		}
		return implicitIndexedPaths;
	}
	
	 
}