package org.springframework.web.servlet.view.json;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

public class JsonWriterConfiguratorTemplateRegistry {
	
	public final static String TEMPLATE_REGISTRY_ATTRIBUTE = JsonWriterConfiguratorTemplateRegistry.class.getName();
	
	@SuppressWarnings("unchecked")
	private Map configuratorTemplates;
	
	@SuppressWarnings("unchecked")
	private JsonWriterConfiguratorTemplateRegistry(){
		configuratorTemplates = new HashMap();
	}
	
	@SuppressWarnings("unchecked")
	public void registerConfiguratorTemplate(JsonWriterConfiguratorTemplate configuratorTemplate){
		configuratorTemplates.put(configuratorTemplate.getRegistryName(), configuratorTemplate);
	}
	
	public JsonWriterConfiguratorTemplate findConfiguratorTemplate(String templateName){
		return (JsonWriterConfiguratorTemplate) configuratorTemplates.get(templateName);
	}
	
	public static JsonWriterConfiguratorTemplateRegistry load(HttpServletRequest request){
		JsonWriterConfiguratorTemplateRegistry registry = (JsonWriterConfiguratorTemplateRegistry) request.getAttribute(TEMPLATE_REGISTRY_ATTRIBUTE);
		if(registry == null){
			registry = new JsonWriterConfiguratorTemplateRegistry();
			request.setAttribute(TEMPLATE_REGISTRY_ATTRIBUTE, registry);
		}
		return registry;
	}

}
