package org.springframework.web.servlet.view.json.exception;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.json.JsonErrorHandler;
import org.springframework.web.servlet.view.json.JsonExceptionHandler;

public class JsonExceptionResolver implements HandlerExceptionResolver {
    
	private String exceptionView; 
	
	private List<JsonExceptionHandler> exceptionHandler = new ArrayList<JsonExceptionHandler>();
	private List<JsonErrorHandler> errorHandler = new ArrayList<JsonErrorHandler>();
	

	
	@SuppressWarnings("unchecked")
	public ModelAndView resolveException(HttpServletRequest request,
			HttpServletResponse response, Object handler, Exception ex) {
		
		if(exceptionView == null || "".equals(exceptionView))
			throw new IllegalArgumentException("Please set the name of the JsonView");
		
		ModelAndView mv = new ModelAndView(exceptionView);
		Map model = new HashMap();
		
		try{
			triggerExceptionHandler(ex, model, request, response);
			triggerErrorHandler( model, request,  response);
			if((exceptionHandler == null || exceptionHandler.size() == 0) && ( errorHandler == null || errorHandler.size() == 0 ))
				throw new IllegalArgumentException("No JsonExceptionHandler or JsonErrorHandler registered!");
		}catch(Exception e){
			StackTraceExceptionHandler errHandler = new StackTraceExceptionHandler();
			try {
				errHandler.triggerException(e, model, request, response);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		mv.addAllObjects(model);
		return mv;
	}
	
	@SuppressWarnings("unchecked")
	protected void triggerErrorHandler(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception{
		if(errorHandler == null || errorHandler.size() == 0)
			return;
		
		for(JsonErrorHandler error: errorHandler){
				error.triggerError(model, null, null, request, response);
		}
	}
	
	@SuppressWarnings("unchecked")
	protected void triggerExceptionHandler(Exception ex, Map model, HttpServletRequest request,
			HttpServletResponse response) throws Exception{
		if(exceptionHandler == null || exceptionHandler.size() == 0)
			return;
		
		for(JsonExceptionHandler exception: exceptionHandler){
			exception.triggerException(ex, model, request, response);
		}
	}

	public String getExceptionView() {
		return exceptionView;
	}

	public void setExceptionView(String exceptionView) {
		this.exceptionView = exceptionView;
	}

	public List<JsonExceptionHandler> getExceptionHandler() {
		return exceptionHandler;
	}

	public void setExceptionHandler(List<JsonExceptionHandler> exceptionHandler) {
		this.exceptionHandler = exceptionHandler;
	}

	public List<JsonErrorHandler> getErrorHandler() {
		return errorHandler;
	}

	public void setErrorHandler(List<JsonErrorHandler> errorHandler) {
		this.errorHandler = errorHandler;
	}
	
	

}
