package org.springframework.web.servlet.view.json.filter;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.JsonViewFilter;

public class SimplePropertyFilter implements JsonViewFilter{
	private Log log = LogFactory.getLog(SimplePropertyFilter.class);
	
	private BeanUtilsBean beanUtilsBean;
	
	private List<String> excludeBeforePropNames;
	private List<String> excludeBeforeErrorsPropNames;
	private List<String> excludeBeforeSuccessPropNames;
	
	public SimplePropertyFilter(){
		setUpBeanUtils();
	}

	protected void setUpBeanUtils() {
		ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
		convertUtilsBean.deregister(Boolean.class);
		convertUtilsBean.deregister(Boolean.TYPE);
		convertUtilsBean.deregister(Byte.class);
		convertUtilsBean.deregister(Byte.TYPE);
		convertUtilsBean.deregister(Character.class);
		convertUtilsBean.deregister(Character.TYPE);
		convertUtilsBean.deregister(Double.class);
		convertUtilsBean.deregister(Double.TYPE);
		convertUtilsBean.deregister(Float.class);
		convertUtilsBean.deregister(Float.TYPE);
		convertUtilsBean.deregister(Long.class);
		convertUtilsBean.deregister(Long.TYPE);
		convertUtilsBean.deregister(Short.class);
		convertUtilsBean.deregister(Short.TYPE);
		
		beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());
	}

	public void filterBeforePopulate(Map model, String commandName) throws Exception {
		filter(model, excludeBeforePropNames, commandName);
	}

	public void filterBeforePopulateErrors(Map model, String commandName) throws Exception {
		filter(model, excludeBeforeErrorsPropNames, commandName);
	}

	public void filterBeforePopulateSuccess(Map model, String commandName) throws Exception {
		filter(model, excludeBeforeSuccessPropNames, commandName);
	}
	
	private void filter(Map model, List<String> properties, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException{
		if(properties != null){
			for(String prop: properties){
				removePropertyValue(model, prop, commandName);
			}
		}
	}
	
	
	private void removePropertyValue(Map model, String property, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException{
		String p = null;
		if(property.matches("^\\(.+\\)|^\\(.+\\)\\..+"))
			p =  property.replaceFirst("\\(", "").replaceFirst("\\)", "");
		else
			p =  new StringBuilder().append(commandName).append(".").append(property).toString();
		
		try{
			if(log.isDebugEnabled())log.debug(p +" = " + BeanUtils.getProperty(model, p));
			beanUtilsBean.setProperty(model, p, null);
			if(log.isDebugEnabled())log.debug(p +" set to " + BeanUtils.getProperty(model, p));
			if(log.isDebugEnabled())log.debug("======================================");
		}catch(Exception e){
			if(log.isDebugEnabled())log.debug("Error excluding property: " + p + ": " + e.toString());
		}
	}

	public List<String> getExcludeBeforePropNames() {
		return excludeBeforePropNames;
	}

	public void setExcludeBeforePropNames(List<String> excludeBeforePropNames) {
		this.excludeBeforePropNames = excludeBeforePropNames;
	}

	public List<String> getExcludeBeforeErrorsPropNames() {
		return excludeBeforeErrorsPropNames;
	}

	public void setExcludeBeforeErrorsPropNames(
			List<String> excludeBeforeErrorsPropNames) {
		this.excludeBeforeErrorsPropNames = excludeBeforeErrorsPropNames;
	}

	public List<String> getExcludeBeforeSuccessPropNames() {
		return excludeBeforeSuccessPropNames;
	}

	public void setExcludeBeforeSuccessPropNames(
			List<String> excludeBeforeSuccessPropNames) {
		this.excludeBeforeSuccessPropNames = excludeBeforeSuccessPropNames;
	}

    

	

	
}
