package org.springframework.web.servlet.view.json.writer.jsonlib;

import java.beans.PropertyEditor;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.JsonEventListener;

import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement;
import org.springframework.web.servlet.view.path.CommonsBeanUtilslPathTracker;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement.Typ;

public class PropertyEditorRegistryValueProcessor implements JsonValueProcessor, JsonEventListener{
	private PropertyEditorRegistry propertyEditorRegistry;
	private String objektName;
	private boolean convertAllMapValues;
	
	private CommonsBeanUtilslPathTracker pathTracker = null;
	private boolean inObject;
	int uniqueName = 0;
		
	public PropertyEditorRegistryValueProcessor(PropertyEditorRegistry propertyEditorRegistry) {
		pathTracker = new CommonsBeanUtilslPathTracker();
		pathTracker.pushElement("map", new CommonsBeanUtilsPathElement("", Typ.MAP));
		this.propertyEditorRegistry = propertyEditorRegistry;
	}

	public Object processArrayValue(Object value, JsonConfig jsonConfig) {
		if(!inObject){
			pushElement(Integer.toString(uniqueName++), value);
		}
	
	
		PropertyEditor pe = null;
		if(propertyEditorRegistry != null){
			String path = pathTracker.getPath().toString();
			String p = path.replaceAll("^\\(" + objektName + "\\)\\.", "");
			
			if (path.equals(p) && convertAllMapValues) {
				pe = propertyEditorRegistry.findCustomEditor( value.getClass(), p);
			} else if (!path.equals(p)) {
				pe = propertyEditorRegistry.findCustomEditor( value.getClass(), p);
			}
		}
		
		if(pe == null && (java.util.Date.class.equals(value.getClass()) || java.sql.Date.class.equals(value.getClass()))){
			pathTracker.popElement();
			return value.toString();
		}
		if(pe != null){
			pe.setValue(value);
			if(!inObject)
				pathTracker.popElement();
			return pe.getAsText();
		}else if(JsonVerifier.isValidJsonValue(value)){
			if(!inObject)
				pathTracker.popElement();
			return value;
		}else{
			if( value instanceof Enum ){
				Object obj = JSONArray.fromObject(value);
				pathTracker.popElement();
				return obj;
			}else if(JSONUtils.isArray(value)){
				Object obj = JSONArray.fromObject(value, jsonConfig);
				pathTracker.popElement();
				return obj;
			} else if( value instanceof Float ){
					return  ((Float)value).doubleValue();
			}else{
				Object obj = JSONObject.fromObject(value, jsonConfig);
				pathTracker.popElement();
				return obj;
			}
		}
	}

	

	public Object processObjectValue(String key, Object value,	JsonConfig jsonConfig) {
		
		pushElement(key, value);
		
		PropertyEditor pe = null;
		
		if(propertyEditorRegistry != null && value != null){
			String path = pathTracker.getPath().toString();
			String p = path.replaceAll("^\\(" + objektName + "\\).", "");
			
			if (path.equals(p) && convertAllMapValues) {
				pe = propertyEditorRegistry.findCustomEditor( value.getClass(), p);
			} else if (!path.equals(p)) {
				pe = propertyEditorRegistry.findCustomEditor( value.getClass(), p);
			}
		}
		
		if(pe == null && value != null && (java.util.Date.class.equals(value.getClass()) || java.sql.Date.class.equals(value.getClass()))){
			pathTracker.popElement();
			return value.toString();
		}
		if(pe != null){
			pe.setValue(value);
			pathTracker.popElement();
			return pe.getAsText();
		}else if(JsonVerifier.isValidJsonValue(value)){
			pathTracker.popElement();
			return value;
		}else{
			if( value instanceof Enum ){
				Object obj = JSONArray.fromObject(value);
				pathTracker.popElement();
				return obj;
			}else if(JSONUtils.isArray(value)){
				Object obj = JSONArray.fromObject(value, jsonConfig);
				pathTracker.popElement();
				return obj;
			}else if( value instanceof Float ){
					return  ((Float)value).doubleValue();
			}else{
				Object obj = JSONObject.fromObject(value, jsonConfig);
				pathTracker.popElement();
				return obj;
			}
		}
	}
	
	
	private void pushElement(String key, Object value) {
		CommonsBeanUtilsPathElement element = new CommonsBeanUtilsPathElement(
				key);
		if (JSONUtils.isArray(value))
			element.setTyp(Typ.ARRAY);
		else if (value instanceof Map)
			element.setTyp(Typ.MAP);
		else
			element.setTyp(Typ.SIMPEL);
		pathTracker.pushElement(key, element);

	}

	public void onArrayEnd() {
		inObject = false;
	}

	public void onArrayStart() {
		inObject = false;
	}

	public void onElementAdded(int index, Object element) {
		
	}

	public void onError(JSONException jsone) {
		
	}

	public void onObjectEnd() {
		inObject = false;
	}

	public void onObjectStart() {
		inObject = true;
	}

	public void onPropertySet(String key, Object value, boolean accumulated) {
		
	}

	public void onWarning(String warning) {
		
	}
	
	public PropertyEditorRegistry getPropertyEditorRegistry() {
		return propertyEditorRegistry;
	}

	public boolean isConvertAllMapValues() {
		return convertAllMapValues;
	}

	public void setConvertAllMapValues(boolean convertAllMapValues) {
		this.convertAllMapValues = convertAllMapValues;
	}

	public String getObjektName() {
		return objektName;
	}

	public void setObjektName(String objektName) {
		this.objektName = objektName;
	}

	protected CommonsBeanUtilslPathTracker getPathTracker() {
		return pathTracker;
	}

	protected void setPathTracker(CommonsBeanUtilslPathTracker pathTracker) {
		this.pathTracker = pathTracker;
	}
	
	
	
}
