package org.springframework.web.servlet.view.json.writer.sojo;

import java.util.ArrayList;
import java.util.List;

import net.sf.sojo.common.WalkerInterceptor;


public class SojoConfig {
	
	private boolean convertAllMapValues = false;
	
	private boolean ignoreNullValues = true;
	
	private String excludedProperties[] = null;
	
	private List<WalkerInterceptor> interceptorList = new ArrayList<WalkerInterceptor>();
	
	private String keepValueTypesMode;
	
	public List<WalkerInterceptor> getInterceptors(){
		return interceptorList;
	}
	
	public void addInterceptor(WalkerInterceptor pvInterceptor) {
		interceptorList.add(pvInterceptor);
	}
	
	public WalkerInterceptor removeInterceptorByNumber(int pvPosition) {
		return interceptorList.remove(pvPosition);
	}
	
	public void setInterceptors(List<WalkerInterceptor>interceptorList ){
		this.interceptorList = interceptorList;
	}
	
	public boolean isConvertAllMapValues() {
		return convertAllMapValues;
	}
	
	public void setConvertAllMapValues(boolean convertAllMapValues) {
		this.convertAllMapValues = convertAllMapValues;
	}
	
	public boolean isIgnoreNullValues() {
		return ignoreNullValues;
	}
	
	public void setIgnoreNullValues(boolean ignoreNullValues) {
		this.ignoreNullValues = ignoreNullValues;
	}
	
	public String[] getExcludedProperties() {
		return excludedProperties;
	}
	public void setExcludedProperties(String[] excludedProperties) {
		this.excludedProperties = excludedProperties;
	}

	public String getKeepValueTypesMode() {
		return keepValueTypesMode;
	}

	public void setKeepValueTypesMode(String keepValueTypesMode) {
		this.keepValueTypesMode = keepValueTypesMode;
	}
	
	
}
