package org.springframework.web.servlet.view.json.writer.xstream;

import org.springframework.web.servlet.view.json.writer.xstream.converter.SimpleDateConverter;
import org.springframework.web.servlet.view.json.writer.xstream.converter.SpringJsonMapConverter;
import org.springframework.web.servlet.view.json.writer.xstream.core.PropertyEditorRegistryConverterLookup;
import org.springframework.web.servlet.view.json.writer.xstream.core.SpringJsonMarshallingStrategy;
import org.springframework.web.servlet.view.json.writer.xstream.io.JsonMapHierarchicalStreamDriver;

import com.thoughtworks.xstream.core.util.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
 
public class SpringJsonXStreamBuilder {
	
	
	public static SpringJsonXStream build(boolean convertAllMapValues, String keepValueTypesMode, String rootname){
		return build(convertAllMapValues, keepValueTypesMode, rootname, false, null, null );
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, String keepValueTypesMode, String rootname, boolean prettyPrint){
		return build(convertAllMapValues, keepValueTypesMode, rootname, prettyPrint, null, null );
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, 	String keepValueTypesMode, String rootname, Class[] processAnnotationsForTypes, Boolean autodetectAnnotations){
		return build(convertAllMapValues, keepValueTypesMode, rootname, false, processAnnotationsForTypes, autodetectAnnotations );
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, 	String keepValueTypesMode, String rootname, boolean prettyPrint, Class[] processAnnotationsForTypes, Boolean autodetectAnnotations) {
		return build(convertAllMapValues, keepValueTypesMode, rootname, false, processAnnotationsForTypes, autodetectAnnotations , null);
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, 	String keepValueTypesMode, String rootname, Class[] processAnnotationsForTypes, Boolean autodetectAnnotations, Class commandClass) {
		return build(convertAllMapValues, keepValueTypesMode, rootname, false, processAnnotationsForTypes, autodetectAnnotations , commandClass);
	}
	
	public static SpringJsonXStream build(boolean convertAllMapValues, 	String keepValueTypesMode, String rootname, boolean prettyPrint, Class[] processAnnotationsForTypes, Boolean autodetectAnnotations, Class commandClass) {
		PropertyEditorRegistryConverterLookup lookup = new PropertyEditorRegistryConverterLookup();
		SpringJsonXStream xstream = new SpringJsonXStream( 
				null, 
				new JsonMapHierarchicalStreamDriver(keepValueTypesMode, prettyPrint), 
				new ClassLoaderReference(new CompositeClassLoader()), 
				null, lookup, null);
		SpringJsonMarshallingStrategy marshallingStrategy  = new SpringJsonMarshallingStrategy(SpringJsonMarshallingStrategy.ABSOLUTE, convertAllMapValues, rootname);
		xstream.setMarshallingStrategy( marshallingStrategy);
		xstream.registerConverter(new SpringJsonMapConverter(xstream.getMapper()));
		xstream.registerConverter(new SimpleDateConverter());
		
		
		if(processAnnotationsForTypes != null && processAnnotationsForTypes.length > 0)
			xstream.processAnnotations(processAnnotationsForTypes);
		else if(commandClass != null)
			xstream.processAnnotations(new Class[]{commandClass});
		
		if(autodetectAnnotations != null)
			xstream.autodetectAnnotations(autodetectAnnotations);
		else{
			xstream.autodetectAnnotations(false);
		}
		
		return xstream;
	}
	
	
	
	
	
	
	
}
