package org.springframework.web.servlet.view.json.writer.xstream.core;

import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.AbstractTreeMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;


public class SpringJsonMarshallingStrategy extends AbstractTreeMarshallingStrategy {

    public static int RELATIVE = 0;
    public static int ABSOLUTE = 1;
    private final int mode;
    private boolean convertAllMapValues;
    private String  rootname;
    

    public SpringJsonMarshallingStrategy(int mode, boolean convertAllMapValues, String rootname) {
        this.mode = mode;
        this.convertAllMapValues = convertAllMapValues;
        this.rootname = rootname;
    }

    protected TreeUnmarshaller createUnmarshallingContext(Object root,
        HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
    	throw new UnsupportedOperationException("No Json Unmarshalling supported!");
    }

    protected TreeMarshaller createMarshallingContext(
        HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        return new CustomEditorMarshaller(writer, converterLookup, mapper, mode, convertAllMapValues, rootname);
    }
    
    
}

