package org.springframework.web.servlet.view.path;

public class CommonsBeanUtilsPathElement{
		public enum Typ { SIMPEL, MAP, ARRAY }

	
    	private String name;
    	private Typ typ;
    	private int index;
    	
    	public CommonsBeanUtilsPathElement(String name, Typ typ) {
			super();
			this.name = name;
			this.typ = typ;
		}
		public CommonsBeanUtilsPathElement(String name) {
			super();
			this.name = name;
		}
		public String getName() {
			return name;
		}
		
		public Typ getTyp() {
			return typ;
		}
		public void setTyp(Typ typ) {
			this.typ = typ;
		}
		public int getIndex() {
			return index;
		}
		public void setIndex(int index) {
			this.index = index;
		}
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((name == null) ? 0 : name.hashCode());
			return result;
		}
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			CommonsBeanUtilsPathElement other = (CommonsBeanUtilsPathElement) obj;
			if (name == null) {
				if (other.name != null)
					return false;
			} else if (!name.equals(other.name))
				return false;
			return true;
		}
		
		public String toString(){
			return "PathElement[name:"+name+";typ:" + typ + ";index:"+index+"]";
		}
    	
    }



