/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.internal.SizeAwareTypes;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.MinSize;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import org.apache.commons.lang.ObjectUtils;

public class Lists {
    public static <A> void addAfter(@NonNull List<A> list, A element, A reference) {
        Ensure.isNotNull((String)"var0", list);
        ListIterator<A> iter = list.listIterator();
        while (iter.hasNext()) {
            if (!ObjectUtils.equals(iter.next(), reference)) continue;
            iter.add(element);
            return;
        }
        throw new NoSuchElementException(reference.toString());
    }

    public static <A> void addBefore(@NonNull List<A> list, A element, A reference) {
        Ensure.isNotNull((String)"var0", list);
        ListIterator<A> iter = list.listIterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(reference)) continue;
            iter.previous();
            iter.add(element);
            return;
        }
        throw new NoSuchElementException(reference.toString());
    }

    public static <A> A removeLast(@NonNull List<A> list) {
        Ensure.isNotNull((String)"var0", list);
        return list.remove(list.size() - 1);
    }

    public static <A> A first(@NotEmpty List<A> list) {
        Ensure.that().isNotEmpty("var0", list);
        return list.get(0);
    }

    public static <A> A second(@MinSize(value=2) List<A> list) {
        Ensure.that().isMinSize("var0", list, 2, SizeAwareTypes.COLLECTION);
        return list.get(1);
    }

    public static <A> A third(@MinSize(value=3) List<A> list) {
        Ensure.that().isMinSize("var0", list, 3, SizeAwareTypes.COLLECTION);
        return list.get(2);
    }

    public static <A> A last(@NotEmpty List<A> list) {
        Ensure.that().isNotEmpty("var0", list);
        return list.get(list.size() - 1);
    }

    @Constant
    public static <A> Class<List<A>> type() {
        return List.class;
    }

    public static <A> List<A> from(A ... elements) {
        return new UnmodifiableArrayList<A>(elements);
    }

    private static class UnmodifiableArrayList<A>
    extends AbstractList<A>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -5513852306359377448L;
        private final A[] a;

        UnmodifiableArrayList(A[] array) {
            if (array == null) {
                throw new NullPointerException();
            }
            this.a = array;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.a, size, a.getClass());
            }
            System.arraycopy(this.a, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public A get(int index) {
            return this.a[index];
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                int i = 0;
                while (i < this.a.length) {
                    if (this.a[i] == null) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.a.length) {
                    if (o.equals(this.a[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }
}

