/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.internal.iterator;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class ZipIterator<A, B, C>
extends AdvanceThriterator<C> {
    private final Thriter<A> thriter1;
    private final Thriter<B> thriter2;
    private final Function2<A, B, C> function;

    public ZipIterator(@NonNull Thriter<A> thriter1, @NonNull Thriter<B> thriter2, @NonNull Function2<A, B, C> function) {
        this.thriter1 = thriter1;
        this.thriter2 = thriter2;
        this.function = function;
    }

    public boolean hasNext() {
        return this.thriter1.hasNext() && this.thriter2.hasNext();
    }

    public void advanceNext() throws NoSuchElementException {
        this.thriter1.advanceNext();
        this.thriter2.advanceNext();
    }

    public C current() throws NoSuchElementException {
        return (C)this.function.apply(this.thriter1.current(), this.thriter2.current());
    }

    public Thunk<C> delayedCurrent() {
        return this.function.delayedValue(this.thriter1.delayedCurrent(), this.thriter2.delayedCurrent());
    }
}

