/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.internal.CharSequenceStream;
import net.sf.staccatocommons.collections.stream.internal.CollectionStream;
import net.sf.staccatocommons.collections.stream.internal.DequeStream;
import net.sf.staccatocommons.collections.stream.internal.EmptyStream;
import net.sf.staccatocommons.collections.stream.internal.IterableStream;
import net.sf.staccatocommons.collections.stream.internal.IteratorStream;
import net.sf.staccatocommons.collections.stream.internal.ListStream;
import net.sf.staccatocommons.collections.stream.internal.SingleStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.DelayedRepatIterator;
import net.sf.staccatocommons.collections.stream.internal.algorithms.IterateStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.RepeatIterator;
import net.sf.staccatocommons.collections.stream.internal.algorithms.UndefinedStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.delayed.ConsStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.delayed.DelayedSingleStream;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.EnumerationIterator;
import net.sf.staccatocommons.lang.internal.Add;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.lang.thunk.Thunks;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.IgnoreRestrictions;

public class Streams {
    private Streams() {
    }

    public static <A> Stream<A> cons(Thunk<A> head, @NonNull Stream<? extends A> tail) {
        Ensure.isNotNull((String)"var1", tail);
        return new ConsStream<A>(head, tail);
    }

    public static <A> Stream<A> cons(A head, @NonNull Stream<? extends A> tail) {
        Ensure.isNotNull((String)"var1", tail);
        return new ConsStream<A>(Thunks.constant(head), tail);
    }

    public static <A> Stream<A> cons(A ... elements) {
        Ensure.isNotNull((String)"var0", elements);
        return Streams.from(Arrays.asList(elements));
    }

    public static <A> Stream<A> cons(Thunk<A> element) {
        return new DelayedSingleStream<A>(element);
    }

    public static <A> Stream<A> cons(A element) {
        return new SingleStream<A>(element);
    }

    @IgnoreRestrictions
    public static <A> Stream<A> iterate(@NonNull A seed, @NonNull Applicable<? super A, ? extends A> generator) {
        return new IterateStream<A>(seed, generator);
    }

    public static Stream<Integer> enumerate(int start) {
        return Streams.iterate(start, Add.one());
    }

    public static Stream<Integer> enumerate(int start, int stop) {
        return Streams.enumerate(start, stop, 1);
    }

    public static Stream<Integer> enumerate(int start, int stop, int step) {
        return Streams.iterate(start, Add.add((int)step)).take(Math.max(0, 1 + (stop - start) / step));
    }

    @IgnoreRestrictions
    public static <A> Stream<A> iterateUntilNull(@NonNull A seed, @NonNull Applicable<? super A, ? extends A> generator) {
        return Streams.iterate(seed, generator).takeWhile((Evaluable)Predicates.notNull());
    }

    public static <A> Stream<A> repeat(A element) {
        return Streams.from(new RepeatIterator<A>(element));
    }

    public static <A> Stream<A> repeat(@NonNull Thunk<A> thunk) {
        Ensure.isNotNull((String)"var0", thunk);
        return Streams.from(new DelayedRepatIterator<A>(thunk));
    }

    public static <A> Stream<A> from(@NonNull Iterable<? extends A> iterable) {
        Ensure.isNotNull((String)"var0", iterable);
        return iterable instanceof Stream ? (Stream<Object>)iterable : new IterableStream<A>(iterable);
    }

    @IgnoreRestrictions
    public static <A> Stream<A> from(@NonNull Iterator<? extends A> iterator) {
        return new IteratorStream<A>(iterator);
    }

    public static <A> Stream<A> from(@NonNull Enumeration<? extends A> enumeration) {
        Ensure.isNotNull((String)"var0", enumeration);
        return Streams.from(new EnumerationIterator(enumeration));
    }

    public static Stream<Character> from(@NonNull CharSequence charSequence) {
        Ensure.isNotNull((String)"var0", (Object)charSequence);
        return new CharSequenceStream(charSequence);
    }

    public static <A> Stream<A> from(@NonNull Collection<? extends A> collection) {
        Ensure.isNotNull((String)"var0", collection);
        return new CollectionStream<A>(collection);
    }

    public static <A> Stream<A> from(@NonNull List<? extends A> list) {
        Ensure.isNotNull((String)"var0", list);
        return new ListStream<A>(list);
    }

    @NonNull
    public static <A> Stream<A> from(@NonNull Deque<? extends A> list) {
        Ensure.isNotNull((String)"var0", list);
        return new DequeStream(list);
    }

    @Constant
    public static <A> Stream<A> empty() {
        return EmptyStream.empty();
    }

    @Constant
    public static <A> Stream<A> undefined() {
        return UndefinedStream.undefined();
    }

    @Constant
    public static <A> Class<Stream<A>> type() {
        return Stream.class;
    }
}

