/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.Reader;
import java.util.Iterator;
import java.util.Scanner;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.internal.iterator.NextOptionIterator;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.io.LineIterator;

public class IOStreams {
    private IOStreams() {
    }

    @NonNull
    public static Stream<String> fromWords(@NonNull Readable readable) {
        Ensure.isNotNull((String)"var0", (Object)readable);
        return Streams.from((Iterator)new Scanner(readable));
    }

    @NonNull
    public static Stream<String> fromWords(@NonNull InputStream in) {
        Ensure.isNotNull((String)"var0", (Object)in);
        return IOStreams.fromWords(new InputStreamReader(in));
    }

    @NonNull
    public static Stream<String> fromLines(@NonNull Reader readable) {
        Ensure.isNotNull((String)"var0", (Object)readable);
        return Streams.from((Iterator)new LineIterator(readable));
    }

    @NonNull
    public static Stream<String> fromLines(@NonNull InputStream in) {
        Ensure.isNotNull((String)"var0", (Object)in);
        return IOStreams.fromLines(new InputStreamReader(in));
    }

    @NonNull
    public static Stream<String> fromTokens(@NonNull Readable readable, @NonNull String regexp) {
        Ensure.isNotNull((String)"var1", (Object)regexp);
        Ensure.isNotNull((String)"var0", (Object)readable);
        return Streams.from((Iterator)new Scanner(readable).useDelimiter(regexp));
    }

    @NonNull
    public static Stream<String> fromTokens(@NonNull InputStream in, @NonNull String regexp) {
        Ensure.isNotNull((String)"var1", (Object)regexp);
        Ensure.isNotNull((String)"var0", (Object)in);
        return IOStreams.fromTokens(new InputStreamReader(in), regexp);
    }

    @NonNull
    public static <A> Stream<A> fromObjects(final @NonNull ObjectInput readable) {
        Ensure.isNotNull((String)"var0", (Object)readable);
        return Streams.from((Iterator)new NextOptionIterator<A>(){

            protected Option<A> nextOption() {
                try {
                    return (Option)Option.some((Object)readable.readObject());
                }
                catch (EOFException eOFException) {
                    return (Option)Option.none();
                }
                catch (Exception e) {
                    throw SoftException.soften((Exception)e);
                }
            }
        });
    }
}

