/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.serialization;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.staccatocommons.io.serialization.CharSerializationManager;
import net.sf.staccatocommons.io.serialization.lifecycle.CharSerializationLifecycle;

public abstract class AbstractCharSerializationManager
implements CharSerializationManager {
    @Override
    public <T> T deserialize(String string) {
        return this.deserialize(new StringReader(string));
    }

    @Override
    public <T> T deserialize(InputStream inputStream) {
        return this.deserialize(new InputStreamReader(inputStream));
    }

    @Override
    public String serialize(Object target) {
        StringWriter writer = new StringWriter();
        this.serialize(target, writer);
        return writer.toString();
    }

    @Override
    public void serialize(Object target, OutputStream output) {
        this.serialize(target, new OutputStreamWriter(output));
    }

    @Override
    public <T> T deserialize(final File input) {
        return (T)new CharSerializationLifecycle.Deserialize<T>(this){

            @Override
            public Reader initialize() throws IOException {
                return new FileReader(input);
            }
        }.value();
    }

    @Override
    public void serialize(Object target, final File output) {
        new CharSerializationLifecycle.Serialize(this, target){

            @Override
            public Writer initialize() throws IOException {
                return new FileWriter(output);
            }
        }.value();
    }
}

