/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.serialization.lifecycle;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.io.internal.lifecycle.CloseableLifecycle;
import net.sf.staccatocommons.io.serialization.CharSerializationManager;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class CharSerializationLifecycle<TargetType extends Closeable, ReturnType>
extends CloseableLifecycle<TargetType, ReturnType> {
    private CharSerializationManager charSerializationManager;

    public CharSerializationLifecycle(@NonNull CharSerializationManager charSerializationManager) {
        Ensure.isNotNull((String)"var0", (Object)charSerializationManager);
        this.charSerializationManager = charSerializationManager;
    }

    public CharSerializationManager getSerializationManager() {
        return this.charSerializationManager;
    }

    public static abstract class Deserialize<A>
    extends CharSerializationLifecycle<Reader, A> {
        public Deserialize(@NonNull CharSerializationManager serializationManager) {
            Ensure.isNotNull((String)"var0", (Object)serializationManager);
            super(serializationManager);
        }

        @Override
        public A doWork(Reader input) throws IOException {
            return (A)this.getSerializationManager().deserialize(input);
        }
    }

    public static abstract class Serialize
    extends CharSerializationLifecycle<Writer, Void> {
        private final Object target;

        public Serialize(@NonNull CharSerializationManager serializationManager, Object target) {
            Ensure.isNotNull((String)"var0", (Object)serializationManager);
            super(serializationManager);
            this.target = target;
        }

        @Override
        public void doVoidWork(Writer output) throws IOException {
            this.getSerializationManager().serialize(this.target, output);
        }
    }
}

