/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.serialization.lifecycle;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.io.internal.lifecycle.CloseableLifecycle;
import net.sf.staccatocommons.io.serialization.SerializationManager;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class SerializationLifecycle<TargetType extends Closeable, ReturnType>
extends CloseableLifecycle<TargetType, ReturnType> {
    private final SerializationManager serializationManager;

    public SerializationLifecycle(@NonNull SerializationManager serializationManager) {
        Ensure.isNotNull((String)"var0", (Object)serializationManager);
        this.serializationManager = serializationManager;
    }

    @NonNull
    public SerializationManager getSerializationManager() {
        return this.serializationManager;
    }

    public static abstract class Deserialize<A>
    extends SerializationLifecycle<InputStream, A> {
        public Deserialize(@NonNull SerializationManager serializationManager) {
            Ensure.isNotNull((String)"var0", (Object)serializationManager);
            super(serializationManager);
        }

        @Override
        protected A doWork(@NonNull InputStream resource) throws Exception {
            return (A)this.getSerializationManager().deserialize(resource);
        }
    }

    public static abstract class Serialize
    extends SerializationLifecycle<OutputStream, Void> {
        private final Object target;

        public Serialize(@NonNull SerializationManager serializationManager, Object target) {
            Ensure.isNotNull((String)"var0", (Object)serializationManager);
            super(serializationManager);
            this.target = target;
        }

        @Override
        public void doVoidWork(@NonNull OutputStream output) throws IOException {
            Ensure.isNotNull((String)"var0", (Object)output);
            this.getSerializationManager().serialize(this.target, output);
        }
    }
}

