/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.iterators.thriter.internal.ConstantThunk;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class AppendThriterator<A>
extends AdvanceThriterator<A> {
    private final Thriter<? extends A> iterator;
    private final A element;
    private boolean unconsumed;

    public AppendThriterator(@NonNull Thriter<? extends A> iterator, A element) {
        Ensure.isNotNull((String)"var0", iterator);
        this.unconsumed = true;
        this.iterator = iterator;
        this.element = element;
    }

    public AppendThriterator(@NonNull Iterator<? extends A> iterator, A element) {
        Ensure.isNotNull((String)"var0", iterator);
        this((Thriter)Thriterators.from(iterator), element);
    }

    public AppendThriterator(@NonNull Thriterator<? extends A> iterator, A element) {
        Ensure.isNotNull((String)"var0", iterator);
        this((Thriter<? extends A>)iterator, (A)element);
    }

    @Override
    public final boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        return this.unconsumed;
    }

    @Override
    public final void advanceNext() throws NoSuchElementException {
        if (this.iterator.hasNext()) {
            this.iterator.advanceNext();
        } else if (this.unconsumed) {
            this.unconsumed = false;
        } else {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final A current() throws NoSuchElementException {
        if (this.unconsumed) {
            return this.iterator.current();
        }
        return this.elementValue();
    }

    protected A elementValue() {
        return this.element;
    }

    protected Thunk<A> elementThunk() {
        return new ConstantThunk<A>(this.element);
    }

    @Override
    public Thunk<A> delayedCurrent() {
        if (this.unconsumed) {
            return this.iterator.delayedCurrent();
        }
        return this.elementThunk();
    }
}

