/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.iterators.thriter;

import java.util.Iterator;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.ArrayThriterator;
import net.sf.staccatocommons.iterators.EmptyThriterator;
import net.sf.staccatocommons.iterators.SingleThriterator;
import net.sf.staccatocommons.iterators.delayed.DelayedSingleIterator;
import net.sf.staccatocommons.iterators.thriter.IteratorThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Thriterators {
    private Thriterators() {
    }

    @Constant
    public static <A> Thriterator<A> empty() {
        return EmptyThriterator.empty();
    }

    @NonNull
    public static <A> Thriterator<A> from(A element) {
        return new SingleThriterator<A>(element);
    }

    @NonNull
    public static <A> Thriterator<A> from(A ... elements) {
        Ensure.isNotNull((String)"var0", elements);
        return new ArrayThriterator<A>(elements);
    }

    public static <A> Thriterator<A> from(@NonNull Thunk<A> thunk) {
        Ensure.isNotNull((String)"var0", thunk);
        return new DelayedSingleIterator<A>(thunk);
    }

    @NonNull
    public static <A> Thriterator<A> from(@NonNull Iterator<? extends A> iter) {
        Ensure.isNotNull((String)"var0", iter);
        if (iter instanceof Thriterator) {
            return (Thriterator)iter;
        }
        return new IteratorThriterator<A>(iter);
    }
}

