/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.function.Function3;
import net.sf.staccatocommons.defs.partial.FirstAware;
import net.sf.staccatocommons.defs.partial.FourthAware;
import net.sf.staccatocommons.defs.partial.SecondAware;
import net.sf.staccatocommons.defs.partial.ThirdAware;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.defs.predicate.Predicate2;
import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.defs.tuple.Tuple3;
import net.sf.staccatocommons.defs.tuple.Tuple4;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.AbstractFunction3;
import net.sf.staccatocommons.lang.function.Functions;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.lang.tuple.Pair;
import net.sf.staccatocommons.lang.tuple.Quadruple;
import net.sf.staccatocommons.lang.tuple.Triple;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Tuples {
    private static final Function FIRST = Tuples.firstInitializer();
    private static final Function SECOND = Tuples.secondInitializer();
    private static final Function THIRD = Tuples.thirdInitializer();
    private static final Function FOURTH = Tuples.fourthInitializer();
    private static final Function3 TO_TUPLE3 = Tuples.toTuple3Initializer();
    private static final Function2 TO_TUPLE2 = Tuples.toTuple2Initializer();

    @Constant
    public static <A> Function<FirstAware<A>, A> first() {
        return FIRST;
    }

    @Constant
    public static <A> Function<SecondAware<A>, A> second() {
        return SECOND;
    }

    @Constant
    public static <A> Function<ThirdAware<A>, A> third() {
        return THIRD;
    }

    @Constant
    public static <A> Function<FourthAware<A>, A> fourth() {
        return FOURTH;
    }

    @NonNull
    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> _(T1 first, T2 second, T3 third, T4 fourth) {
        return new Quadruple<T1, T2, T3, T4>(first, second, third, fourth);
    }

    @NonNull
    public static <T1, T2, T3> Tuple3<T1, T2, T3> _(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    @NonNull
    public static <T1, T2> Tuple2<T1, T2> _(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    @Constant
    public static <T1, T2, T3> Function3<T1, T2, T3, Tuple3<T1, T2, T3>> toTuple3() {
        return TO_TUPLE3;
    }

    @Constant
    public static <T1, T2> Function2<T1, T2, Tuple2<T1, T2>> toTuple2() {
        return TO_TUPLE2;
    }

    public static <A, B, C> Function2<A, B, C> curry(final Function<Tuple2<A, B>, C> function) {
        return new AbstractFunction2<A, B, C>(){

            public C apply(A arg0, B arg1) {
                return function.apply(Tuples._(arg0, arg1));
            }
        };
    }

    public static <A, B, C, D> Function3<A, B, C, D> curry3(final Function<Tuple3<A, B, C>, D> function) {
        return new AbstractFunction3<A, B, C, D>(){

            public D apply(A arg0, B arg1, C arg2) {
                return function.apply(Tuples._(arg0, arg1, arg2));
            }
        };
    }

    public static <A, B> Predicate2<A, B> curry(final Predicate<Tuple2<A, B>> predicate) {
        return new AbstractPredicate2<A, B>(){

            public boolean eval(A arg0, B arg1) {
                return predicate.eval(Tuples._(arg0, arg1));
            }
        };
    }

    public static <A, B, C, D> Function<Tuple2<A, B>, Tuple2<C, D>> zip(final Applicable<? super A, ? extends C> function0, final Applicable<? super B, ? extends D> function1) {
        return new AbstractFunction<Tuple2<A, B>, Tuple2<C, D>>(){

            public Tuple2<C, D> apply(Tuple2<A, B> arg) {
                return Tuples._(function0.apply(arg._0()), function1.apply(arg._1()));
            }
        };
    }

    public static <A, B, C> Function<Tuple2<A, B>, C> merge(final Applicable<? super B, ? extends C> function) {
        return new AbstractFunction<Tuple2<A, B>, C>(){

            public C apply(Tuple2<A, B> arg) {
                return function.apply(arg._1());
            }
        };
    }

    public static <A, B, C> Function<A, Tuple2<B, C>> branch(final Applicable<? super A, ? extends B> function0, final Applicable<? super A, ? extends C> function1) {
        return new AbstractFunction<A, Tuple2<B, C>>(){

            public Tuple2<B, C> apply(A arg) {
                return Tuples._(function0.apply(arg), function1.apply(arg));
            }
        };
    }

    public static <A, B> Function<A, Tuple2<A, B>> clone(Applicable<? super A, ? extends B> function0) {
        return Tuples.branch((Applicable)Functions.identity(), function0);
    }

    private static Function firstInitializer() {
        return new AbstractFunction<FirstAware<A>, A>(){

            public A apply(FirstAware<A> arg) {
                return arg._0();
            }
        };
    }

    private static Function secondInitializer() {
        return new AbstractFunction<SecondAware<A>, A>(){

            public A apply(SecondAware<A> arg) {
                return arg._1();
            }
        };
    }

    private static Function thirdInitializer() {
        return new AbstractFunction<ThirdAware<A>, A>(){

            public A apply(ThirdAware<A> arg) {
                return arg._2();
            }
        };
    }

    private static Function fourthInitializer() {
        return new AbstractFunction<FourthAware<A>, A>(){

            public A apply(FourthAware<A> arg) {
                return arg._3();
            }
        };
    }

    private static Function3 toTuple3Initializer() {
        return new AbstractFunction3<T1, T2, T3, Tuple3<T1, T2, T3>>(){

            public Tuple3<T1, T2, T3> apply(T1 arg0, T2 arg1, T3 arg2) {
                return Tuples._(arg0, arg1, arg2);
            }
        };
    }

    private static Function2 toTuple2Initializer() {
        return new AbstractFunction2<T1, T2, Tuple2<T1, T2>>(){

            public Tuple2<T1, T2> apply(T1 arg0, T2 arg1) {
                return Tuples._(arg0, arg1);
            }
        };
    }
}

