/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

public interface ReadableDeviceCategory {
    @Nonnull
    public Category getCategory();

    @Nonnull
    public String getIcon();

    @Nonnull
    public String getInfoUrl();

    @Nonnull
    public String getName();

    public static enum Category {
        GAME_CONSOLE("Game console"),
        OTHER("Other"),
        PDA("PDA"),
        PERSONAL_COMPUTER("Personal computer"),
        SMART_TV("Smart TV"),
        SMARTPHONE("Smartphone"),
        TABLET("Tablet"),
        UNKNOWN("");

        @Nonnull
        private final String name;

        public static Category evaluate(@Nonnull String categoryName) {
            Check.notNull((Object)categoryName, (String)"categoryName");
            Category result = UNKNOWN;
            for (Category value : Category.values()) {
                if (!value.getName().equals(categoryName)) continue;
                result = value;
                break;
            }
            return result;
        }

        private Category(String name) {
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }
    }
}

