/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

public enum OperatingSystemFamily {
    AIX("AIX", Pattern.compile("AIX")),
    AROS("AROS", Pattern.compile("AROS")),
    AMIGA_OS("Amiga OS", Pattern.compile("Amiga OS")),
    ANDROID("Android", Pattern.compile("Android")),
    BSD("BSD", Pattern.compile("BSD")),
    BADA("Bada", Pattern.compile("Bada")),
    BEOS("BeOS", Pattern.compile("BeOS")),
    DANGEROS("DangerOS", Pattern.compile("DangerOS")),
    FIREFOX_OS("Firefox OS", Pattern.compile("Firefox OS")),
    HPUX("HP-UX", Pattern.compile("HP-UX")),
    HAIKU("Haiku OS", Pattern.compile("Haiku OS")),
    IRIX("IRIX", Pattern.compile("IRIX")),
    INFERNO_OS("Inferno OS", Pattern.compile("Inferno OS")),
    JVM("JVM", Pattern.compile("JVM")),
    LINUX("Linux", Pattern.compile("Linux")),
    MAC_OS("Mac OS", Pattern.compile("Mac OS")),
    MINIX("MINIX", Pattern.compile("MINIX")),
    OPENVMS("OpenVMS", Pattern.compile("OpenVMS")),
    OS_X("OS X", Pattern.compile("(Mac OS X|OS X)")),
    MORPHOS("MorphOS", Pattern.compile("MorphOS")),
    NINTENDO("Nintendo", Pattern.compile("Nintendo")),
    OS_2("OS/2", Pattern.compile("OS/2")),
    PALM_OS("Palm OS", Pattern.compile("Palm OS")),
    PLAYSTATION_VITA("LiveArea", Pattern.compile("LiveArea")),
    QNX("QNX", Pattern.compile("QNX")),
    RISC_OS("RISC OS", Pattern.compile("RISC OS|RISK OS")),
    BLACKBERRY_OS("BlackBerry OS", Pattern.compile("(RIM OS|BlackBerry OS)")),
    SAILFISH_OS("Sailfish", Pattern.compile("Sailfish")),
    SOLARIS("Solaris", Pattern.compile("Solaris")),
    SYLLABLE("Syllable", Pattern.compile("Syllable")),
    SYMBIAN("Symbian OS", Pattern.compile("Symbian OS")),
    TIZEN("Tizen", Pattern.compile("Tizen")),
    WII_OS("Wii OS", Pattern.compile("Nintendo Wii|Wii OS")),
    WINDOWS("Windows", Pattern.compile("Windows")),
    XROSSMEDIABAR("XrossMediaBar (XMB)", Pattern.compile("XrossMediaBar (XMB)")),
    IOS("iOS", Pattern.compile("iOS|iPhone OS")),
    WEBOS("webOS", Pattern.compile("webOS")),
    UNKNOWN("", Pattern.compile("^$"));

    @Nonnull
    private final String name;
    @Nonnull
    private final Pattern pattern;

    public static OperatingSystemFamily evaluate(@Nonnull String family) {
        Check.notNull((Object)family, (String)"family");
        OperatingSystemFamily result = UNKNOWN;
        result = OperatingSystemFamily.evaluateByName(family);
        if (result == UNKNOWN) {
            result = OperatingSystemFamily.evaluateByPattern(family);
        }
        return result;
    }

    protected static OperatingSystemFamily evaluateByName(@Nonnull String family) {
        Check.notNull((Object)family, (String)"family");
        OperatingSystemFamily result = UNKNOWN;
        for (OperatingSystemFamily value : OperatingSystemFamily.values()) {
            if (!value.getName().equals(family)) continue;
            result = value;
            break;
        }
        return result;
    }

    protected static OperatingSystemFamily evaluateByPattern(@Nonnull String family) {
        Check.notNull((Object)family, (String)"family");
        OperatingSystemFamily result = UNKNOWN;
        for (OperatingSystemFamily value : OperatingSystemFamily.values()) {
            Matcher m = value.getPattern().matcher(family);
            if (!m.matches()) continue;
            result = value;
            break;
        }
        return result;
    }

    private OperatingSystemFamily(String name, Pattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Pattern getPattern() {
        return this.pattern;
    }
}

