/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.ReadableOperatingSystem;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.UserAgentFamily;
import net.sf.uadetector.UserAgentType;
import net.sf.uadetector.VersionNumber;

public final class UserAgent
implements ReadableUserAgent,
Serializable {
    public static final UserAgent EMPTY = new UserAgent(UserAgentFamily.UNKNOWN, "", "unknown", OperatingSystem.EMPTY, "", "", UserAgentType.UNKNOWN, "", "", VersionNumber.UNKNOWN);
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final UserAgentFamily family;
    @Nonnull
    private final String icon;
    @Nonnull
    private final String name;
    @Nonnull
    private final OperatingSystem operatingSystem;
    @Nonnull
    private final String producer;
    @Nonnull
    private final String producerUrl;
    @Nonnull
    private final UserAgentType type;
    @Nonnull
    private final String typeName;
    @Nonnull
    private final String url;
    @Nonnull
    private final VersionNumber versionNumber;

    public UserAgent(@Nonnull UserAgentFamily family, @Nonnull String icon, @Nonnull String name, @Nonnull OperatingSystem operatingSystem, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull UserAgentType type, @Nonnull String typeName, @Nonnull String url, @Nonnull VersionNumber versionNumber) {
        Check.notNull((Object)((Object)family), (String)"family");
        Check.notNull((Object)icon, (String)"icon");
        Check.notNull((Object)name, (String)"name");
        Check.notNull((Object)operatingSystem, (String)"operatingSystem");
        Check.notNull((Object)producer, (String)"producer");
        Check.notNull((Object)producerUrl, (String)"producerUrl");
        Check.notNull((Object)((Object)type), (String)"type");
        Check.notNull((Object)typeName, (String)"typeName");
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)versionNumber, (String)"versionNumber");
        this.family = family;
        this.icon = icon;
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.type = type;
        this.typeName = typeName;
        this.url = url;
        this.versionNumber = versionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)obj;
        if (!this.family.equals((Object)other.family)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.typeName.equals(other.typeName)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return this.versionNumber.equals(other.versionNumber);
    }

    @Override
    public UserAgentFamily getFamily() {
        return this.family;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public String getProducer() {
        return this.producer;
    }

    @Override
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Override
    public UserAgentType getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.operatingSystem.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.versionNumber.hashCode();
        return result;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserAgent [family=");
        builder.append((Object)this.family);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", operatingSystem=");
        builder.append(this.operatingSystem);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", typeName=");
        builder.append(this.typeName);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", versionNumber=");
        builder.append(this.versionNumber);
        builder.append("]");
        return builder.toString();
    }

    static /* synthetic */ UserAgentFamily access$000(UserAgent x0) {
        return x0.family;
    }

    static /* synthetic */ String access$100(UserAgent x0) {
        return x0.icon;
    }

    static /* synthetic */ String access$200(UserAgent x0) {
        return x0.name;
    }

    static /* synthetic */ String access$300(UserAgent x0) {
        return x0.producer;
    }

    static /* synthetic */ String access$400(UserAgent x0) {
        return x0.producerUrl;
    }

    static /* synthetic */ UserAgentType access$500(UserAgent x0) {
        return x0.type;
    }

    static /* synthetic */ String access$600(UserAgent x0) {
        return x0.typeName;
    }

    static /* synthetic */ String access$700(UserAgent x0) {
        return x0.url;
    }

    public static final class Builder
    implements ReadableUserAgent {
        private UserAgentFamily family = UserAgent.access$000(EMPTY);
        private String icon = UserAgent.access$100(EMPTY);
        private String name = UserAgent.access$200(EMPTY);
        private OperatingSystem operatingSystem = OperatingSystem.EMPTY;
        private String producer = UserAgent.access$300(EMPTY);
        private String producerUrl = UserAgent.access$400(EMPTY);
        private UserAgentType type = UserAgent.access$500(EMPTY);
        private String typeName = UserAgent.access$600(EMPTY);
        private String url = UserAgent.access$700(EMPTY);
        private String userAgentString = "";
        private VersionNumber versionNumber = VersionNumber.UNKNOWN;

        public Builder() {
        }

        public Builder(@Nonnull String userAgentString) {
            Check.notNull((Object)userAgentString, (String)"userAgentString");
            this.userAgentString = userAgentString;
        }

        @Nonnull
        public UserAgent build() {
            return new UserAgent(this.family, this.icon, this.name, this.operatingSystem, this.producer, this.producerUrl, this.type, this.typeName, this.url, this.versionNumber);
        }

        @Override
        public UserAgentFamily getFamily() {
            return this.family;
        }

        @Override
        public String getIcon() {
            return this.icon;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public String getProducer() {
            return this.producer;
        }

        @Override
        public String getProducerUrl() {
            return this.producerUrl;
        }

        @Override
        public UserAgentType getType() {
            return this.type;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public String getUserAgentString() {
            return this.userAgentString;
        }

        @Override
        public VersionNumber getVersionNumber() {
            return this.versionNumber;
        }

        @Nonnull
        public Builder setFamily(@Nonnull UserAgentFamily family) {
            Check.notNull((Object)((Object)family), (String)"family");
            this.family = family;
            return this;
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            Check.notNull((Object)icon, (String)"icon");
            this.icon = icon;
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            Check.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder setOperatingSystem(@Nonnull OperatingSystem operatingSystem) {
            Check.notNull((Object)operatingSystem, (String)"operatingSystem");
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Nonnull
        public Builder setOperatingSystem(@Nonnull ReadableOperatingSystem os) {
            Check.notNull((Object)os, (String)"os");
            this.operatingSystem = new OperatingSystem(os.getFamily(), os.getFamilyName(), os.getIcon(), os.getName(), os.getProducer(), os.getProducerUrl(), os.getUrl(), os.getVersionNumber());
            return this;
        }

        @Nonnull
        public Builder setProducer(@Nonnull String producer) {
            Check.notNull((Object)producer, (String)"producer");
            this.producer = producer;
            return this;
        }

        @Nonnull
        public Builder setProducerUrl(@Nonnull String producerUrl) {
            Check.notNull((Object)producerUrl, (String)"producerUrl");
            this.producerUrl = producerUrl;
            return this;
        }

        @Nonnull
        public Builder setType(@Nonnull UserAgentType type) {
            Check.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.typeName = type.getName();
            return this;
        }

        @Nonnull
        public Builder setTypeName(@Nonnull String typeName) {
            Check.notNull((Object)typeName, (String)"typeName");
            this.type = UserAgentType.evaluateByTypeName(typeName);
            this.typeName = typeName;
            return this;
        }

        @Nonnull
        public Builder setUrl(@Nonnull String url) {
            Check.notNull((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder setUserAgentString(@Nonnull String userAgentString) {
            Check.notNull((Object)userAgentString, (String)"userAgentString");
            this.userAgentString = userAgentString;
            return this;
        }

        @Nonnull
        public Builder setVersionNumber(@Nonnull VersionNumber versionNumber) {
            Check.notNull((Object)versionNumber, (String)"versionNumber");
            this.versionNumber = versionNumber;
            return this;
        }
    }
}

