/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datareader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datareader.DataReader;
import net.sf.uadetector.exception.CanNotOpenStreamException;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.DataBuilder;
import net.sf.uadetector.internal.data.XmlDataHandler;
import net.sf.uadetector.internal.util.Closeables;
import net.sf.uadetector.internal.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDataReader
implements DataReader {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(XmlDataReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Data readXml(@Nonnull InputStream inputStream, @Nonnull Charset charset) {
        Check.notNull((Object)inputStream, (String)"inputStream");
        Check.notNull((Object)charset, (String)"charset");
        DataBuilder builder = new DataBuilder();
        boolean hasErrors = false;
        try {
            XmlParser.parse(inputStream, builder);
        }
        catch (ParserConfigurationException e) {
            hasErrors = true;
            LOG.warn(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            hasErrors = true;
            LOG.warn(e.getLocalizedMessage());
        }
        catch (IOException e) {
            hasErrors = true;
            LOG.warn(e.getLocalizedMessage());
        }
        catch (IllegalStateException e) {
            hasErrors = true;
            LOG.warn(e.getLocalizedMessage());
        }
        catch (Exception e) {
            hasErrors = true;
            LOG.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            Closeables.closeAndConvert(inputStream, true);
        }
        return hasErrors ? Data.EMPTY : builder.build();
    }

    @Override
    public Data read(@Nonnull String data) {
        Check.notNull((Object)data, (String)"data");
        return XmlDataReader.readXml(new ByteArrayInputStream(data.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET);
    }

    @Override
    public Data read(@Nonnull URL url, @Nonnull Charset charset) {
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)charset, (String)"charset");
        Data data = Data.EMPTY;
        try {
            data = XmlDataReader.readXml(UrlUtil.open(url), charset);
        }
        catch (CanNotOpenStreamException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        return data;
    }

    protected static final class XmlParser {
        private static final String MSG_NOT_PARSED_AS_EXPECTED = "The UAS data has not been parsed as expected.";

        public static void parse(@Nonnull InputStream stream, @Nonnull DataBuilder builder) throws ParserConfigurationException, SAXException, IOException {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            XmlDataHandler handler = new XmlDataHandler(builder);
            parser.parse(stream, (DefaultHandler)handler);
            XmlParser.validate(handler);
        }

        protected static void validate(@Nonnull XmlDataHandler handler) {
            if (handler.hasError() || handler.hasWarning()) {
                throw new IllegalStateException(MSG_NOT_PARSED_AS_EXPECTED);
            }
        }

        private XmlParser() {
        }
    }
}

