/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import net.sf.uadetector.exception.CannotCloseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Closeables {
    private static final Logger LOG = LoggerFactory.getLogger(Closeables.class);

    public static void close(@Nullable Closeable closeable, boolean swallowIOException) throws IOException {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (!swallowIOException) {
                    throw e;
                }
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void closeAndConvert(@Nullable Closeable closeable, boolean swallowIOException) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (!swallowIOException) {
                    throw new CannotCloseException(e.getLocalizedMessage(), e);
                }
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private Closeables() {
    }
}

