/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.uadetector.exception.CanNotOpenStreamException;
import net.sf.uadetector.internal.util.Closeables;

public final class UrlUtil {
    public static URL build(@Nonnull String url) {
        Check.notNull((Object)url, (String)"url");
        URL ret = null;
        try {
            ret = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateOfArgumentException("The given string is not a valid URL: " + url, (Throwable)e);
        }
        return ret;
    }

    public static InputStream open(@Nonnull URL url) {
        InputStream ret;
        Check.notNull((Object)url, (String)"url");
        try {
            ret = url.openStream();
        }
        catch (IOException e) {
            throw new CanNotOpenStreamException(url.toString(), e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(@Nonnull URL url, @Nonnull Charset charset) throws IOException {
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)charset, (String)"charset");
        InputStream inputStream = UrlUtil.open(url);
        BufferedReader reader = null;
        StringBuilder buffer = new StringBuilder();
        boolean threw = true;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            buffer.append(UrlUtil.readAll(reader));
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(reader, threw);
            Closeables.close(inputStream, false);
            throw throwable;
        }
        Closeables.close(reader, threw);
        Closeables.close(inputStream, false);
        return buffer.toString();
    }

    private static String readAll(@Nonnull Reader reader) throws IOException {
        int cp;
        StringBuilder buffer = new StringBuilder();
        while ((cp = reader.read()) != -1) {
            buffer.append((char)cp);
        }
        return buffer.toString();
    }

    public static URL toUrl(@Nonnull File file) {
        Check.notNull((Object)file, (String)"file");
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Can not construct an URL for passed file.", e);
        }
        return url;
    }

    private UrlUtil() {
    }
}

