/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.parser;

import java.util.Map;
import java.util.regex.Matcher;
import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;

public abstract class AbstractUserAgentStringParser
implements UserAgentStringParser {
    private static final int ZERO_MATCHING_GROUPS = 0;

    private static void examineAsBrowser(UserAgent.Builder builder, Data data) {
        VersionNumber version = VersionNumber.UNKNOWN;
        for (Map.Entry<BrowserPattern, Browser> entry : data.getPatternToBrowserMap().entrySet()) {
            Matcher matcher = entry.getKey().getPattern().matcher(builder.getUserAgentString());
            if (!matcher.find()) continue;
            entry.getValue().copyTo(builder);
            if (matcher.groupCount() > 0) {
                version = VersionNumber.parseVersion(matcher.group(1) != null ? matcher.group(1) : "");
            }
            builder.setVersionNumber(version);
            break;
        }
    }

    private static boolean examineAsRobot(UserAgent.Builder builder, Data data) {
        boolean isRobot = false;
        for (Robot robot : data.getRobots()) {
            if (!robot.getUserAgentString().equals(builder.getUserAgentString())) continue;
            isRobot = true;
            robot.copyTo(builder);
            VersionNumber version = VersionNumber.parseLastVersionNumber(robot.getName());
            builder.setVersionNumber(version);
            break;
        }
        return isRobot;
    }

    private static void examineOperatingSystem(UserAgent.Builder builder, Data data) {
        if (OperatingSystem.EMPTY.equals(builder.getOperatingSystem())) {
            for (Map.Entry<OperatingSystemPattern, net.sf.uadetector.internal.data.domain.OperatingSystem> entry : data.getPatternToOperatingSystemMap().entrySet()) {
                Matcher matcher = entry.getKey().getPattern().matcher(builder.getUserAgentString());
                if (!matcher.find()) continue;
                entry.getValue().copyTo(builder);
                break;
            }
        }
    }

    protected abstract DataStore getDataStore();

    @Override
    public String getDataVersion() {
        return this.getDataStore().getData().getVersion();
    }

    @Override
    public UserAgent parse(String userAgent) {
        UserAgent.Builder builder = new UserAgent.Builder(userAgent);
        Data data = this.getDataStore().getData();
        if (!AbstractUserAgentStringParser.examineAsRobot(builder, data)) {
            AbstractUserAgentStringParser.examineAsBrowser(builder, data);
            AbstractUserAgentStringParser.examineOperatingSystem(builder, data);
        }
        return builder.build();
    }

    @Override
    public void shutdown() {
    }
}

