/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.parser;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datastore.RefreshableDataStore;
import net.sf.uadetector.internal.util.ExecutorServices;
import net.sf.uadetector.parser.UserAgentStringParserImpl;

public final class UpdatingUserAgentStringParserImpl
extends UserAgentStringParserImpl<RefreshableDataStore> {
    public static final long DEFAULT_UPDATE_INTERVAL = 86400000L;
    private long updateInterval = 86400000L;
    private ScheduledFuture<?> currentUpdateTask;
    private final ScheduledExecutorService scheduler = ExecutorServices.createScheduler();

    public UpdatingUserAgentStringParserImpl(RefreshableDataStore store) {
        super(store);
        this.setUpUpdateService();
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(@Nonnegative long updateInterval) {
        Check.notNegative((long)updateInterval, (String)"updateInterval");
        this.updateInterval = updateInterval;
        this.setUpUpdateService();
    }

    private void setUpUpdateService() {
        if (this.currentUpdateTask != null) {
            this.currentUpdateTask.cancel(false);
        }
        this.currentUpdateTask = this.scheduler.scheduleWithFixedDelay(((RefreshableDataStore)this.getDataStore()).getUpdateOperation(), 0L, this.updateInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.currentUpdateTask.cancel(false);
        ExecutorServices.shutdown(this.scheduler);
        ((RefreshableDataStore)this.getDataStore()).getUpdateOperation().shutdown();
    }
}

