/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.datareader;

import java.net.URL;
import java.nio.charset.Charset;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datareader.DataReader;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.util.UrlUtil;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.JsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonDataReader
implements DataReader {
    private static final Logger LOG = LoggerFactory.getLogger(JsonDataReader.class);

    public Data read(URL url, Charset charset) {
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)charset, (String)"charset");
        try {
            String json = UrlUtil.read((URL)url, (Charset)charset);
            return this.read(json);
        }
        catch (Exception e) {
            LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            return Data.EMPTY;
        }
    }

    public Data read(String json) {
        Check.notNull((Object)json, (String)"json");
        try {
            return JsonConverter.deserialize(json, SerDeOption.HASH_VALIDATING).getData();
        }
        catch (Exception e) {
            LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            return Data.EMPTY;
        }
    }
}

