/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data;

import java.util.Arrays;
import java.util.EnumSet;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.Deserialization;
import net.sf.uadetector.json.internal.data.deserializer.Deserializers;
import net.sf.uadetector.json.internal.data.serializer.Serialization;
import net.sf.uadetector.json.internal.data.serializer.Serializers;

public final class JsonConverter {
    private static final EnumSet<SerDeOption> WITHOUT_SPECIAL_OPTIONS = EnumSet.noneOf(SerDeOption.class);

    private static EnumSet<SerDeOption> convertOptions(SerDeOption ... options) {
        EnumSet<SerDeOption> opts = options != null ? EnumSet.copyOf(Arrays.asList(options)) : EnumSet.noneOf(SerDeOption.class);
        return opts;
    }

    public static Deserialization<Data> deserialize(String json) {
        Check.notNull((Object)json);
        return JsonConverter.deserialize(json, WITHOUT_SPECIAL_OPTIONS);
    }

    public static Deserialization<Data> deserialize(String json, EnumSet<SerDeOption> options) {
        Check.notNull((Object)json);
        Check.notNull(options);
        return Deserializers.deserialize(json, options);
    }

    public static Deserialization<Data> deserialize(String json, SerDeOption ... options) {
        Check.notNull((Object)json);
        Check.notNull((Object)options);
        return JsonConverter.deserialize(json, JsonConverter.convertOptions(options));
    }

    public static Serialization serialize(Data data) {
        Check.notNull((Object)data);
        return JsonConverter.serialize(data, EnumSet.noneOf(SerDeOption.class));
    }

    public static Serialization serialize(Data data, EnumSet<SerDeOption> options) {
        Check.notNull((Object)data);
        Check.notNull(options);
        return Serializers.serialize(data, options);
    }

    public static Serialization serialize(Data data, SerDeOption ... options) {
        Check.notNull((Object)data);
        return JsonConverter.serialize(data, JsonConverter.convertOptions(options));
    }

    private JsonConverter() {
    }
}

